/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.gui.volume;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.maxhenkel.voicechat.gui.GameProfileUtils;
import de.maxhenkel.voicechat.gui.volume.AdjustVolumeSlider;
import de.maxhenkel.voicechat.gui.volume.PlayerVolumesScreen;
import de.maxhenkel.voicechat.gui.widgets.ListScreenEntryBase;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import java.util.Collections;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;

public class PlayerVolumeEntry
extends ListScreenEntryBase<PlayerVolumeEntry> {
    protected static final TranslatableComponent OTHER_VOLUME = new TranslatableComponent("message.voicechat.other_volume");
    protected static final TranslatableComponent OTHER_VOLUME_DESCRIPTION = new TranslatableComponent("message.voicechat.other_volume.description");
    protected static final ResourceLocation OTHER_VOLUME_ICON = new ResourceLocation("voicechat", "textures/icons/other_volume.png");
    protected static final int SKIN_SIZE = 24;
    protected static final int PADDING = 4;
    protected static final int BG_FILL = FastColor.ARGB32.m_13660_((int)255, (int)74, (int)74, (int)74);
    protected static final int PLAYER_NAME_COLOR = FastColor.ARGB32.m_13660_((int)255, (int)255, (int)255, (int)255);
    protected final Minecraft minecraft = Minecraft.m_91087_();
    @Nullable
    protected final PlayerState state;
    protected final PlayerVolumesScreen screen;
    protected final AdjustVolumeSlider volumeSlider;

    public PlayerVolumeEntry(@Nullable PlayerState state, PlayerVolumesScreen screen) {
        this.state = state;
        this.screen = screen;
        this.volumeSlider = new AdjustVolumeSlider(0, 0, 100, 20, state != null ? state.getUuid() : Util.f_137441_);
        this.children.add(this.volumeSlider);
    }

    public void m_6311_(PoseStack poseStack, int index, int top, int left, int width, int height, int mouseX, int mouseY, boolean hovered, float delta) {
        int skinX = left + 4;
        int skinY = top + (height - 24) / 2;
        int textX = skinX + 24 + 4;
        Objects.requireNonNull(this.minecraft.f_91062_);
        int textY = top + (height - 9) / 2;
        GuiComponent.m_93172_((PoseStack)poseStack, (int)left, (int)top, (int)(left + width), (int)(top + height), (int)BG_FILL);
        if (this.state != null) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)GameProfileUtils.getSkin(this.state.getUuid()));
            GuiComponent.m_93160_((PoseStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69478_();
            GuiComponent.m_93160_((PoseStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
            RenderSystem.m_69461_();
            this.minecraft.f_91062_.m_92883_(poseStack, this.state.getName(), (float)textX, (float)textY, PLAYER_NAME_COLOR);
        } else {
            RenderSystem.m_157456_((int)0, (ResourceLocation)OTHER_VOLUME_ICON);
            GuiComponent.m_93160_((PoseStack)poseStack, (int)skinX, (int)skinY, (int)24, (int)24, (float)16.0f, (float)16.0f, (int)16, (int)16, (int)16, (int)16);
            this.minecraft.f_91062_.m_92889_(poseStack, (Component)OTHER_VOLUME, (float)textX, (float)textY, PLAYER_NAME_COLOR);
            if (hovered) {
                this.screen.postRender(() -> this.screen.m_96617_(poseStack, Collections.singletonList(OTHER_VOLUME_DESCRIPTION.m_7532_()), mouseX, mouseY));
            }
        }
        this.volumeSlider.f_93620_ = left + (width - this.volumeSlider.m_5711_() - 4);
        this.volumeSlider.f_93621_ = top + (height - this.volumeSlider.m_93694_()) / 2;
        this.volumeSlider.m_6305_(poseStack, mouseX, mouseY, delta);
    }

    @Nullable
    public PlayerState getState() {
        return this.state;
    }
}

