/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.Server;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PingManager {
    private final Map<UUID, Ping> listeners;
    private final Server server;

    public PingManager(Server server) {
        this.server = server;
        this.listeners = new HashMap<UUID, Ping>();
    }

    public void onPongPacket(PingPacket packet) {
        Voicechat.LOGGER.info("Received pong {}", (Object)packet.getId());
        Ping ping = this.listeners.remove(packet.getId());
        if (ping == null) {
            return;
        }
        ping.listener.onPong(packet);
    }

    public void checkTimeouts() {
        if (this.listeners.isEmpty()) {
            return;
        }
        List<Map.Entry> timedOut = this.listeners.entrySet().stream().filter(uuidPingEntry -> ((Ping)uuidPingEntry.getValue()).isTimedOut()).toList();
        for (Map.Entry ping : timedOut) {
            ((Ping)ping.getValue()).listener.onTimeout();
            this.listeners.remove(ping.getKey());
        }
    }

    public void sendPing(ClientConnection connection, long timeout, PingListener listener) throws Exception {
        UUID id = UUID.randomUUID();
        long timestamp = System.currentTimeMillis();
        this.listeners.put(id, new Ping(listener, timestamp, timeout));
        this.server.sendPacket(new PingPacket(id, timestamp), connection);
        Voicechat.LOGGER.info("Sent ping {}", (Object)id);
    }

    private static class Ping {
        private final PingListener listener;
        private final long timestamp;
        private final long timeout;

        public Ping(PingListener listener, long timestamp, long timeout) {
            this.listener = listener;
            this.timestamp = timestamp;
            this.timeout = timeout;
        }

        public boolean isTimedOut() {
            return System.currentTimeMillis() - this.timestamp >= this.timeout;
        }
    }

    public static interface PingListener {
        public void onPong(PingPacket var1);

        public void onTimeout();
    }
}

