/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.lists;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.PregenTask;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PregenTaskList
implements Savable<JsonArray> {
    private static final Logger LOGGER = LogManager.getLogger(PregenTaskList.class);
    private final ArrayList<PregenTask> task_list = new ArrayList();

    public Optional<PregenTask> runFor(ResourceKey<Level> dimension, BiConsumer<ArrayList<PregenTask>, Integer> runner) {
        for (int i = 0; i < this.task_list.size(); ++i) {
            PregenTask task = this.task_list.get(i);
            if (task.getDimension() != dimension) continue;
            runner.accept(this.task_list, i);
            return Optional.of(task);
        }
        return Optional.empty();
    }

    public void addOrReplace(PregenTask new_task) {
        if (new_task == null) {
            return;
        }
        if (this.runFor(new_task.getDimension(), (list, index) -> list.set((int)index, new_task)).isEmpty()) {
            this.task_list.add(new_task);
        }
    }

    public ArrayList<PregenTask> getTaskList() {
        return this.task_list;
    }

    public Optional<PregenTask> getFirst() {
        return this.task_list.isEmpty() ? Optional.empty() : Optional.of(this.task_list.get(0));
    }

    public boolean isEmpty() {
        return this.task_list.isEmpty();
    }

    public Optional<PregenTask> getAndRemoveBy(ResourceKey<Level> dimension) {
        return this.runFor(dimension, (list, index) -> this.task_list.remove((int)index));
    }

    public void removeFirst() {
        this.task_list.remove(0);
    }

    public void removeBy(ResourceKey<Level> dimension) {
        this.runFor(dimension, (list, index) -> this.task_list.remove((int)index));
    }

    public void clear() {
        this.task_list.clear();
    }

    @Override
    @Nonnull
    public JsonArray write() {
        JsonArray json = new JsonArray();
        for (PregenTask task : this.task_list) {
            json.add((JsonElement)task.write());
        }
        return json;
    }

    @Override
    public void read(@Nonnull JsonArray jsonArray) {
        this.clear();
        for (JsonElement element : jsonArray) {
            if (!element.isJsonObject()) continue;
            JsonObject json = element.getAsJsonObject();
            PregenTask task = new PregenTask();
            try {
                task.read(json);
                this.addOrReplace(task);
            }
            catch (IllegalArgumentException exception) {
                LOGGER.error("Invalid task: Task is not added to queue.", (Throwable)exception);
            }
        }
    }

    public void checkTasks(MinecraftServer server) {
        for (int i = 0; i < this.task_list.size(); ++i) {
            PregenTask task = this.task_list.get(i);
            if (!task.isDimensionInvalid(server)) continue;
            this.task_list.remove(i);
            --i;
            LOGGER.error("Invalid task: Task is removed from queue.");
        }
    }
}

