/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen;

import com.google.gson.JsonObject;
import de.geheimagentnr1.world_pre_generator.config.ServerConfig;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.ThreadData;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPos;
import de.geheimagentnr1.world_pre_generator.elements.queues.tasks.pregen.data.WorldPregenData;
import de.geheimagentnr1.world_pre_generator.helpers.DimensionHelper;
import de.geheimagentnr1.world_pre_generator.helpers.JsonHelper;
import de.geheimagentnr1.world_pre_generator.save.Savable;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkStatus;

public class PregenTask
implements Savable<JsonObject> {
    private static final String centerXName = "center_x";
    private static final String centerZName = "center_z";
    private static final String radiusName = "radius";
    private static final String chunkIndexName = "chunk_index";
    private static final String dimensionName = "dimension";
    private int center_x;
    private int center_z;
    private int radius;
    private ResourceKey<Level> dimension;
    private boolean canceled = false;
    private WorldPregenData worldPregenData;
    private final ThreadData threadData = new ThreadData();

    public PregenTask(WorldPos center, int _radius, ResourceKey<Level> _dimension) {
        this.center_x = center.getX();
        this.center_z = center.getZ();
        this.radius = _radius;
        this.dimension = _dimension;
        this.worldPregenData = new WorldPregenData(this.center_x, this.center_z, this.radius);
    }

    public PregenTask() {
    }

    public boolean generate(MinecraftServer server) {
        if (this.canceled) {
            return true;
        }
        if (ServerConfig.isRunParallel()) {
            if (this.threadData.getCount() < ServerConfig.getThreadCount()) {
                this.worldPregenData.nextChunk().ifPresent(currentPos -> {
                    if (this.isNotGenerated(server, (WorldPos)currentPos)) {
                        this.threadData.incCount();
                        new Thread(() -> {
                            this.generate(server, (WorldPos)currentPos);
                            this.threadData.decCount();
                        }).start();
                    }
                });
            }
        } else {
            this.worldPregenData.nextChunk().ifPresent(currentPos -> {
                if (this.isNotGenerated(server, (WorldPos)currentPos)) {
                    this.generate(server, (WorldPos)currentPos);
                }
            });
        }
        return this.worldPregenData.fullyGenerated();
    }

    private boolean isNotGenerated(MinecraftServer server, WorldPos pos) {
        return Objects.requireNonNull(server.m_129880_(this.dimension)).m_7726_().m_7587_(pos.getX(), pos.getZ(), ChunkStatus.f_62326_, false) == null;
    }

    private void generate(MinecraftServer server, WorldPos pos) {
        Objects.requireNonNull(server.m_129880_(this.dimension)).m_7726_().m_7587_(pos.getX(), pos.getZ(), ChunkStatus.f_62326_, true);
    }

    public void cancel() {
        this.canceled = true;
    }

    @Override
    @Nonnull
    public JsonObject write() {
        JsonObject compound = new JsonObject();
        compound.addProperty(centerXName, (Number)this.center_x);
        compound.addProperty(centerZName, (Number)this.center_z);
        compound.addProperty(radiusName, (Number)this.radius);
        compound.addProperty(dimensionName, DimensionHelper.getNameOfDim(this.dimension));
        compound.addProperty(chunkIndexName, (Number)this.getChunkIndex());
        return compound;
    }

    @Override
    public void read(@Nonnull JsonObject json) {
        if (!JsonHelper.isInt(json, centerXName)) {
            throw new IllegalArgumentException("Invalid center x value.");
        }
        this.center_x = JsonHelper.getInt(json, centerXName);
        if (!JsonHelper.isInt(json, centerZName)) {
            throw new IllegalArgumentException("Invalid center z value.");
        }
        this.center_z = JsonHelper.getInt(json, centerZName);
        if (!JsonHelper.isInt(json, radiusName)) {
            throw new IllegalArgumentException("Invalid radius value.");
        }
        this.radius = JsonHelper.getInt(json, radiusName);
        if (JsonHelper.isString(json, dimensionName)) {
            try {
                this.dimension = DimensionHelper.getDimFromName(JsonHelper.getString(json, dimensionName));
            }
            catch (ResourceLocationException exception) {
                throw new IllegalArgumentException("Invalid dimension resource location.", exception);
            }
        } else {
            throw new IllegalArgumentException("Invalid dimension value.");
        }
        this.worldPregenData = new WorldPregenData(this.center_x, this.center_z, this.radius);
        if (!JsonHelper.isInt(json, chunkIndexName)) {
            throw new IllegalArgumentException("Invalid chunk index value.");
        }
        this.worldPregenData.setChunkIndex(JsonHelper.getInt(json, chunkIndexName));
    }

    public boolean isDimensionInvalid(MinecraftServer server) {
        return server.m_129880_(this.dimension) == null;
    }

    public int getCenterX() {
        return this.center_x;
    }

    public int getCenterZ() {
        return this.center_z;
    }

    public int getRadius() {
        return this.radius;
    }

    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public int getChunkIndex() {
        return this.worldPregenData.getChunkIndex();
    }

    public int getChunkCount() {
        return this.worldPregenData.getChunkCount();
    }

    public int getProgress() {
        return this.worldPregenData.getProgess();
    }
}

