/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.render.CustomizableModelPart;
import dev.tr7zw.skinlayers.render.SolidPixelWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;

public class BodyLayerFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final boolean thinArms;
    private static final Minecraft mc = Minecraft.m_91087_();
    private final List<Layer> bodyLayers = new ArrayList<Layer>();

    public BodyLayerFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
        this.thinArms = ((PlayerEntityModelAccessor)this.m_117386_()).hasThinArms();
        this.bodyLayers.add(new Layer(0, false, PlayerModelPart.LEFT_PANTS_LEG, Shape.LEGS, () -> ((PlayerModel)this.m_117386_()).f_102814_, () -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(1, false, PlayerModelPart.RIGHT_PANTS_LEG, Shape.LEGS, () -> ((PlayerModel)this.m_117386_()).f_102813_, () -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(2, false, PlayerModelPart.LEFT_SLEEVE, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((PlayerModel)this.m_117386_()).f_102812_, () -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(3, true, PlayerModelPart.RIGHT_SLEEVE, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((PlayerModel)this.m_117386_()).f_102811_, () -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(4, false, PlayerModelPart.JACKET, Shape.BODY, () -> ((PlayerModel)this.m_117386_()).f_102810_, () -> SkinLayersModBase.config.enableJacket));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer player, float f, float g, float h, float j, float k, float l) {
        if (!player.m_108559_() || player.m_20145_()) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.f_91073_ == null) {
            return;
        }
        if (BodyLayerFeatureRenderer.mc.f_91074_.m_20280_((Entity)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()))) {
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110470_((ResourceLocation)player.m_108560_()));
        int m = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        this.renderLayers(player, settings.getSkinLayers(), poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(AbstractClientPlayer abstractClientPlayer, CustomizableModelPart[] layers, PoseStack matrixStack, VertexConsumer vertices, int light, int overlay) {
        if (layers == null) {
            return;
        }
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = 1.035f;
        float widthScaling = SkinLayersModBase.config.baseVoxelSize;
        boolean red = abstractClientPlayer.f_20916_ > 0 || abstractClientPlayer.f_20919_ > 0;
        float color = red ? 0.5f : 1.0f;
        for (Layer layer : this.bodyLayers) {
            if (!abstractClientPlayer.m_36170_(layer.modelPart) || !layer.vanillaGetter.get().f_104207_ || !layer.configGetter.get().booleanValue()) continue;
            matrixStack.m_85836_();
            layer.vanillaGetter.get().m_104299_(matrixStack);
            if (layer.shape == Shape.ARMS) {
                layers[layer.layersId].x = 0.998f;
            } else if (layer.shape == Shape.ARMS_SLIM) {
                layers[layer.layersId].x = 0.499f;
            }
            if (layer.shape == Shape.BODY) {
                widthScaling = SkinLayersModBase.config.bodyVoxelWidthSize;
            }
            if (layer.mirrored) {
                layers[layer.layersId].x *= -1.0f;
            }
            matrixStack.m_85841_(widthScaling, heightScaling, pixelScaling);
            layers[layer.layersId].y = layer.shape.yOffsetMagicValue;
            layers[layer.layersId].render(matrixStack, vertices, light, overlay, 1.0f, color, color, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private record Layer(int layersId, boolean mirrored, PlayerModelPart modelPart, Shape shape, Supplier<ModelPart> vanillaGetter, Supplier<Boolean> configGetter) {
    }

    private static enum Shape {
        HEAD(0.0f, new SolidPixelWrapper.Dimensions(8, 8, 8)),
        BODY(0.6f, new SolidPixelWrapper.Dimensions(8, 12, 4)),
        LEGS(-0.2f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS(0.4f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS_SLIM(0.4f, new SolidPixelWrapper.Dimensions(3, 14, 4));

        private final float yOffsetMagicValue;
        private final SolidPixelWrapper.Dimensions dimensions;

        private Shape(float yOffsetMagicValue, SolidPixelWrapper.Dimensions dimensions) {
            this.dimensions = dimensions;
            this.yOffsetMagicValue = yOffsetMagicValue;
        }
    }
}

