/*
 * Decompiled with CFR 0.152.
 */
package lilypuree.decorative_blocks.core;

import java.util.HashMap;
import java.util.Map;
import lilypuree.decorative_blocks.blocks.BarPanelBlock;
import lilypuree.decorative_blocks.blocks.BeamBlock;
import lilypuree.decorative_blocks.blocks.BonfireBlock;
import lilypuree.decorative_blocks.blocks.BrazierBlock;
import lilypuree.decorative_blocks.blocks.ChainBlock;
import lilypuree.decorative_blocks.blocks.ChandelierBlock;
import lilypuree.decorative_blocks.blocks.LatticeBlock;
import lilypuree.decorative_blocks.blocks.PalisadeBlock;
import lilypuree.decorative_blocks.blocks.PillarBlock;
import lilypuree.decorative_blocks.blocks.RockyDirtBlock;
import lilypuree.decorative_blocks.blocks.SeatBlock;
import lilypuree.decorative_blocks.blocks.SupportBlock;
import lilypuree.decorative_blocks.blocks.types.IWoodType;
import lilypuree.decorative_blocks.blocks.types.VanillaWoodTypes;
import lilypuree.decorative_blocks.blocks.types.WoodDecorativeBlockTypes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;

public class DBBlocks {
    public static Block BONFIRE;
    public static Block CHANDELIER;
    public static Block BRAZIER;
    public static Block SOUL_CHANDELIER;
    public static Block SOUL_BRAZIER;
    public static Block SOUL_BONFIRE;
    public static Block BAR_PANEL;
    public static Block LATTICE;
    public static Block CHAIN;
    public static Block STONE_PILLAR;
    public static Block ROCKY_DIRT;
    public static Map<IWoodType, BeamBlock> BEAMS;
    public static Map<IWoodType, PalisadeBlock> PALISADES;
    public static Map<IWoodType, SupportBlock> SUPPORTS;
    public static Map<IWoodType, SeatBlock> SEATS;
    public static final BlockBehaviour.Properties chainProperties;

    public static void init() {
        BONFIRE = new BonfireBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76309_, (MaterialColor)MaterialColor.f_76402_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> 15).m_60993_());
        CHANDELIER = new ChandelierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 15), false);
        BRAZIER = new BrazierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 15 : 0).m_60955_(), false);
        SOUL_BONFIRE = new BonfireBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76309_, (MaterialColor)MaterialColor.f_76421_).m_60910_().m_60978_(0.0f).m_60918_(SoundType.f_56745_).m_60953_(state -> 14).m_60993_());
        SOUL_CHANDELIER = new ChandelierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76310_).m_60978_(0.3f).m_60918_(SoundType.f_56736_).m_60955_().m_60953_(state -> 11), true);
        SOUL_BRAZIER = new BrazierBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60918_(SoundType.f_56743_).m_60953_(state -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61443_) != false ? 10 : 0).m_60955_(), true);
        BAR_PANEL = new BarPanelBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60978_(5.0f).m_60918_(SoundType.f_56743_).m_60955_());
        LATTICE = new LatticeBlock(BlockBehaviour.Properties.m_60944_((Material)Material.f_76320_, (MaterialColor)MaterialColor.f_76411_).m_60978_(1.2f).m_60918_(SoundType.f_56736_).m_60955_());
        CHAIN = new ChainBlock(chainProperties);
        STONE_PILLAR = new PillarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 6.5f));
        ROCKY_DIRT = new RockyDirtBlock();
        for (VanillaWoodTypes woodType : VanillaWoodTypes.values()) {
            BEAMS.put(woodType, (BeamBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.BEAM));
            PALISADES.put(woodType, (PalisadeBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.PALISADE));
            SUPPORTS.put(woodType, (SupportBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.SUPPORT));
            SEATS.put(woodType, (SeatBlock)DBBlocks.createDecorativeBlock(woodType, WoodDecorativeBlockTypes.SEAT));
        }
    }

    public static Block createDecorativeBlock(IWoodType wood, WoodDecorativeBlockTypes woodDecorativeBlockType) {
        BlockBehaviour.Properties woodProperty = BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).m_60978_(1.2f).m_60918_(wood.getSoundType());
        BlockBehaviour.Properties palisadeProperty = BlockBehaviour.Properties.m_60944_((Material)wood.getMaterial(), (MaterialColor)wood.getMaterialColor()).m_60913_(2.0f, 4.0f).m_60918_(wood.getSoundType());
        return switch (woodDecorativeBlockType) {
            default -> throw new IncompatibleClassChangeError();
            case WoodDecorativeBlockTypes.BEAM -> new BeamBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SEAT -> new SeatBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.SUPPORT -> new SupportBlock(woodProperty, wood);
            case WoodDecorativeBlockTypes.PALISADE -> new PalisadeBlock(palisadeProperty, wood);
        };
    }

    static {
        BEAMS = new HashMap<IWoodType, BeamBlock>();
        PALISADES = new HashMap<IWoodType, PalisadeBlock>();
        SUPPORTS = new HashMap<IWoodType, SupportBlock>();
        SEATS = new HashMap<IWoodType, SeatBlock>();
        chainProperties = BlockBehaviour.Properties.m_60944_((Material)Material.f_76279_, (MaterialColor)MaterialColor.f_76365_).m_60978_(4.3f).m_60918_(SoundType.f_56743_).m_60955_();
    }
}

