/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;

public class FramedPaneModel
extends FramedBlockModel {
    protected final boolean north;
    protected final boolean east;
    protected final boolean south;
    protected final boolean west;

    public FramedPaneModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
        this.east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
        this.south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
        this.west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        Direction face = quad.m_111306_();
        if (Utils.isY(face)) {
            FramedPaneModel.createTopBottomCenterQuad(quadMap, quad, false);
            if (this.north) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.NORTH, false);
            }
            if (this.east) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.EAST, false);
            }
            if (this.south) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.SOUTH, false);
            }
            if (this.west) {
                FramedPaneModel.createTopBottomEdgeQuad(quadMap, quad, Direction.WEST, false);
            }
        } else {
            FramedPaneModel.createSideEdgeQuad(quadMap, quad, this.isSideInset(face), false);
            if (Utils.isX(face)) {
                if (this.north) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, false);
                }
                if (this.south) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, true);
                }
            }
            if (Utils.isZ(face)) {
                if (this.east) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, true);
                }
                if (this.west) {
                    FramedPaneModel.createSideQuad(quadMap.get(null), quad, false);
                }
            }
        }
    }

    protected static void createTopBottomCenterQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean mirrored) {
        BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, 0.4375f, 0.4375f, 0.5625f, 0.5625f)) {
            if (mirrored) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.001f);
                quadMap.get(null).add(topBotQuad);
            } else {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
        }
    }

    protected static void createTopBottomEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, Direction dir, boolean mirrored) {
        float maxZ;
        float minZ;
        float maxX;
        float minX;
        if (Utils.isY(dir)) {
            throw new IllegalArgumentException(String.format("Invalid direction: %s!", dir));
        }
        boolean positive = Utils.isPositive(dir);
        if (Utils.isX(dir)) {
            minX = positive ? 0.5625f : 0.0f;
            maxX = positive ? 1.0f : 0.4375f;
            minZ = 0.4375f;
            maxZ = 0.5625f;
        } else {
            minX = 0.4375f;
            maxX = 0.5625f;
            minZ = positive ? 0.5625f : 0.0f;
            maxZ = positive ? 1.0f : 0.4375f;
        }
        BakedQuad topBotQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createTopBottomQuad(topBotQuad, minX, minZ, maxX, maxZ)) {
            if (mirrored) {
                BakedQuadTransformer.setQuadPosInFacingDir(topBotQuad, 0.001f);
                quadMap.get(null).add(topBotQuad);
            } else {
                quadMap.get(quad.m_111306_()).add(topBotQuad);
            }
        }
    }

    protected static void createSideEdgeQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, boolean inset, boolean mirrored) {
        if (inset && mirrored) {
            throw new IllegalArgumentException("Quad can't be mirrored and inset!");
        }
        BakedQuad edgeQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(edgeQuad, 0.4375f, 0.0f, 0.5625f, 1.0f)) {
            if (inset) {
                BakedQuadTransformer.setQuadPosInFacingDir(edgeQuad, 0.5625f);
                quadMap.get(null).add(edgeQuad);
            } else if (mirrored) {
                BakedQuadTransformer.setQuadPosInFacingDir(edgeQuad, 0.001f);
                quadMap.get(quad.m_111306_().m_122424_()).add(edgeQuad);
            } else {
                quadMap.get(quad.m_111306_()).add(edgeQuad);
            }
        }
    }

    private static void createSideQuad(List<BakedQuad> quadList, BakedQuad quad, boolean positive) {
        float minXZ = positive ? 0.5625f : 0.0f;
        float maxXZ = positive ? 1.0f : 0.4375f;
        BakedQuad sideQuad = ModelUtils.duplicateQuad(quad);
        if (BakedQuadTransformer.createSideQuad(sideQuad, minXZ, 0.0f, maxXZ, 1.0f)) {
            BakedQuadTransformer.setQuadPosInFacingDir(sideQuad, 0.5625f);
            quadList.add(sideQuad);
        }
    }

    protected boolean isSideInset(Direction face) {
        if (face == Direction.NORTH) {
            return !this.north;
        }
        if (face == Direction.EAST) {
            return !this.east;
        }
        if (face == Direction.SOUTH) {
            return !this.south;
        }
        if (face == Direction.WEST) {
            return !this.west;
        }
        throw new IllegalArgumentException(String.format("Invalid face: %s!", face));
    }
}

