/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.util.client.BakedQuadTransformer;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedPrismCornerModel
extends FramedBlockModel {
    private final Direction dir;
    private final boolean top;
    private final boolean offset;

    public FramedPrismCornerModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        this.dir = (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR);
        this.top = (Boolean)state.m_61143_((Property)PropertyHolder.TOP);
        this.offset = (Boolean)state.m_61143_((Property)PropertyHolder.OFFSET);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        if (quad.m_111306_() == Direction.UP && this.top || quad.m_111306_() == Direction.DOWN && !this.top) {
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createTopBottomTriangleQuad(triQuad, this.dir)) {
                quadMap.get(quad.m_111306_()).add(triQuad);
            }
        } else if (quad.m_111306_() == this.dir || quad.m_111306_() == this.dir.m_122428_()) {
            BakedQuad triQuad = ModelUtils.duplicateQuad(quad);
            if (BakedQuadTransformer.createSideTriangleQuad(triQuad, quad.m_111306_() == this.dir, this.top)) {
                quadMap.get(quad.m_111306_()).add(triQuad);
            }
        } else if (quad.m_111306_() == this.dir.m_122424_()) {
            BakedQuad prismQuad = ModelUtils.duplicateQuad(quad);
            if (!this.offset) {
                if (BakedQuadTransformer.createPrismTriangleQuad(prismQuad, !this.top, true)) {
                    quadMap.get(null).add(prismQuad);
                }
            } else {
                if (BakedQuadTransformer.createVerticalSideQuad(prismQuad, this.dir.m_122427_(), 0.5f)) {
                    BakedQuadTransformer.offsetQuadInDir(prismQuad, this.dir.m_122427_(), 0.5f);
                    if (BakedQuadTransformer.createPrismTriangleQuad(prismQuad, !this.top, true)) {
                        quadMap.get(null).add(prismQuad);
                    }
                }
                if (BakedQuadTransformer.createVerticalSideQuad(prismQuad = ModelUtils.duplicateQuad(quad), this.dir.m_122428_(), 0.5f)) {
                    BakedQuadTransformer.offsetQuadInDir(prismQuad, this.dir.m_122428_(), 0.5f);
                    if (BakedQuadTransformer.createPrismTriangleQuad(prismQuad, !this.top, true)) {
                        quadMap.get(null).add(prismQuad);
                    }
                }
            }
        }
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedPrismCorner.get()).m_49966_().m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)Direction.SOUTH);
    }
}

