/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;

public class FramedSlabEdgeBlock
extends FramedBlock {
    public FramedSlabEdgeBlock() {
        super(BlockType.FRAMED_SLAB_EDGE);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)PropertyHolder.TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{PropertyHolder.FACING_HOR, PropertyHolder.TOP, BlockStateProperties.f_61362_});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = FramedSlabEdgeBlock.withTop(this.m_49966_(), context.m_43719_(), context.m_43720_());
        state = (BlockState)state.m_61124_((Property)PropertyHolder.FACING_HOR, (Comparable)context.m_8125_());
        return FramedSlabEdgeBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return type == PathComputationType.WATER && level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
    }

    public static ImmutableMap<BlockState, VoxelShape> generateShapes(ImmutableList<BlockState> states) {
        VoxelShape bottomShape = FramedSlabEdgeBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0);
        VoxelShape topShape = FramedSlabEdgeBlock.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = Utils.rotateShape(Direction.NORTH, (Direction)state.m_61143_((Property)PropertyHolder.FACING_HOR), (Boolean)state.m_61143_((Property)PropertyHolder.TOP) != false ? topShape : bottomShape);
            builder.put((Object)state, (Object)shape);
        }
        return builder.build();
    }
}

