/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.blockentity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.util.FramedProperties;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.data.CornerType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.util.DoubleSoundMode;

public class FramedDoubleCornerBlockEntity
extends FramedDoubleBlockEntity {
    public FramedDoubleCornerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FBContent.blockEntityTypeDoubleFramedCorner.get(), pos, state);
    }

    @Override
    protected boolean hitSecondary(BlockHitResult hit) {
        CornerType type = (CornerType)((Object)this.m_58900_().m_61143_(PropertyHolder.CORNER_TYPE));
        Direction facing = (Direction)this.m_58900_().m_61143_((Property)PropertyHolder.FACING_HOR);
        Direction side = hit.m_82434_();
        Vec3 vec = Utils.fraction(hit.m_82450_());
        if (type.isHorizontal()) {
            if (side == facing || !type.isTop() && side == Direction.DOWN || type.isTop() && side == Direction.UP || !type.isRight() && side == facing.m_122428_() || type.isRight() && side == facing.m_122427_()) {
                return false;
            }
            if (side == facing.m_122424_()) {
                return true;
            }
            if (Utils.isY(side)) {
                boolean secondary;
                if (type.isRight()) {
                    secondary = Utils.isX(facing) ? vec.m_7096_() >= 1.0 - vec.m_7094_() : vec.m_7094_() >= vec.m_7096_();
                } else {
                    boolean bl = Utils.isX(facing) ? vec.m_7096_() >= vec.m_7094_() : (secondary = vec.m_7094_() >= 1.0 - vec.m_7096_());
                }
                if (Utils.isPositive(facing)) {
                    secondary = !secondary;
                }
                return secondary;
            }
            if (side == facing.m_122427_() || side == facing.m_122428_()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                boolean secondary = type.isTop() ? vec.m_7098_() <= 1.0 - hor : vec.m_7098_() >= hor;
                return secondary;
            }
        } else if (type == CornerType.TOP) {
            if (side == facing || side == Direction.UP || side == facing.m_122428_()) {
                return false;
            }
            if (side == Direction.DOWN) {
                return true;
            }
            if (side == facing.m_122427_()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                return vec.m_7098_() <= 1.0 - hor;
            }
            if (side == facing.m_122424_()) {
                double hor;
                Direction dir = facing.m_122428_();
                double d = hor = Utils.isX(dir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                return vec.m_7098_() <= 1.0 - hor;
            }
        } else if (type == CornerType.BOTTOM) {
            if (side == facing || side == Direction.DOWN || side == facing.m_122428_()) {
                return false;
            }
            if (side == Direction.UP) {
                return true;
            }
            if (side == facing.m_122427_()) {
                double hor;
                double d = hor = Utils.isX(facing) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(facing)) {
                    hor = 1.0 - hor;
                }
                return vec.m_7098_() >= hor;
            }
            if (side == facing.m_122424_()) {
                double hor;
                Direction dir = facing.m_122428_();
                double d = hor = Utils.isX(dir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                return vec.m_7098_() >= hor;
            }
        }
        return false;
    }

    @Override
    public DoubleSoundMode getSoundMode() {
        CornerType type = (CornerType)((Object)this.m_58900_().m_61143_(PropertyHolder.CORNER_TYPE));
        if (type == CornerType.BOTTOM) {
            return DoubleSoundMode.SECOND;
        }
        if (type.isTop()) {
            return DoubleSoundMode.FIRST;
        }
        return DoubleSoundMode.EITHER;
    }

    @Override
    public BlockState getCamoState(Direction side) {
        CornerType type = (CornerType)((Object)this.m_58900_().m_61143_(PropertyHolder.CORNER_TYPE));
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)PropertyHolder.FACING_HOR);
        if (type.isHorizontal()) {
            if (side == dir || !type.isTop() && side == Direction.DOWN || type.isTop() && side == Direction.UP || !type.isRight() && side == dir.m_122428_() || type.isRight() && side == dir.m_122427_()) {
                return this.getCamoState();
            }
            if (side == dir.m_122424_() || !type.isTop() && side == Direction.UP || type.isTop() && side == Direction.DOWN || !type.isRight() && side == dir.m_122427_() || type.isRight() && side == dir.m_122428_()) {
                return this.getCamoStateTwo();
            }
        } else if (type == CornerType.TOP) {
            if (side == dir || side == Direction.UP || side == dir.m_122428_()) {
                return this.getCamoState();
            }
            if (side == dir.m_122424_() || side == Direction.DOWN || side == dir.m_122427_()) {
                return this.getCamoStateTwo();
            }
        } else if (type == CornerType.BOTTOM) {
            if (side == dir || side == Direction.DOWN || side == dir.m_122428_()) {
                return this.getCamoState();
            }
            if (side == dir.m_122424_() || side == Direction.UP || side == dir.m_122427_()) {
                return this.getCamoStateTwo();
            }
        }
        return Blocks.f_50016_.m_49966_();
    }

    @Override
    public boolean isSolidSide(Direction side) {
        CornerType type = (CornerType)((Object)this.m_58900_().m_61143_(PropertyHolder.CORNER_TYPE));
        Direction dir = (Direction)this.m_58900_().m_61143_((Property)PropertyHolder.FACING_HOR);
        if (type.isHorizontal() ? !type.isRight() && side == dir.m_122428_() || type.isRight() && side == dir.m_122427_() || !type.isTop() && side == Direction.DOWN || type.isTop() && side == Direction.UP || side == dir || side == dir.m_122424_() : side == dir || side == dir.m_122428_() || Utils.isY(side)) {
            return this.getCamoState(side).m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
        }
        return this.getCamoState().m_60804_((BlockGetter)this.f_58857_, this.f_58858_) && this.getCamoStateTwo().m_60804_((BlockGetter)this.f_58857_, this.f_58858_);
    }

    @Override
    protected Tuple<BlockState, BlockState> getBlockPair(BlockState state) {
        return FramedDoubleCornerBlockEntity.getBlockPair((CornerType)((Object)state.m_61143_(PropertyHolder.CORNER_TYPE)), (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR));
    }

    public static Tuple<BlockState, BlockState> getBlockPair(CornerType type, Direction facing) {
        return new Tuple((Object)((BlockState)((BlockState)((Block)FBContent.blockFramedInnerCornerSlope.get()).m_49966_().m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)), (Object)((BlockState)((BlockState)((Block)FBContent.blockFramedCornerSlope.get()).m_49966_().m_61124_(PropertyHolder.CORNER_TYPE, (Comparable)((Object)type.verticalOpposite()))).m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing.m_122424_())));
    }
}

