/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.compat.buildinggadgets;

import com.direwolf20.buildinggadgets.common.BuildingGadgets;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.ITileDataSerializer;
import com.direwolf20.buildinggadgets.common.tainted.building.tilesupport.NBTTileEntityData;
import com.direwolf20.buildinggadgets.common.tainted.building.view.BuildContext;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.MaterialList;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.IUniqueObject;
import com.direwolf20.buildinggadgets.common.tainted.inventory.materials.objects.UniqueItem;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import xfacthd.framedblocks.api.block.FramedBlockEntity;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;
import xfacthd.framedblocks.common.compat.buildinggadgets.BuildingGadgetsCompat;
import xfacthd.framedblocks.common.util.FramedUtils;
import xfacthd.framedblocks.common.util.ServerConfig;

class FramedBlockEntityData
extends NBTTileEntityData {
    public FramedBlockEntityData(FramedBlockEntity te) {
        super(te.writeToBlueprint(), FramedBlockEntityData.buildMaterialList(te));
    }

    public FramedBlockEntityData(CompoundTag data, MaterialList materials) {
        super(data, materials);
    }

    public boolean placeIn(BuildContext context, BlockState state, BlockPos pos) {
        BuildingGadgets.LOG.trace("Placing {} with Tile NBT at {}.", (Object)state, (Object)pos);
        context.getWorld().m_7731_(pos, state, 0);
        FramedUtils.enqueueImmediateTask(context.getWorld(), () -> {
            BlockEntity te = context.getWorld().m_7702_(pos);
            if (te != null) {
                CompoundTag nbt = this.getNBT();
                nbt.m_128405_("x", pos.m_123341_());
                nbt.m_128405_("y", pos.m_123342_());
                nbt.m_128405_("z", pos.m_123343_());
                try {
                    te.m_142466_(nbt);
                }
                catch (Exception e) {
                    BuildingGadgets.LOG.debug("Failed to apply Tile NBT Data to {} at {} in Context {}", (Object)state, (Object)pos, (Object)context, (Object)e);
                }
            }
        }, true);
        return true;
    }

    public ITileDataSerializer getSerializer() {
        return (ITileDataSerializer)BuildingGadgetsCompat.FRAMED_SERIALIZER.get();
    }

    private static MaterialList buildMaterialList(FramedBlockEntity be) {
        FramedDoubleBlockEntity dbe;
        MaterialList.SimpleBuilder builder = MaterialList.simpleBuilder();
        if (be.getBlock() == FBContent.blockFramedDoubleSlab.get()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)FBContent.blockFramedSlab.get())), UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)FBContent.blockFramedSlab.get()))});
        } else if (be.getBlock() == FBContent.blockFramedDoublePanel.get()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)FBContent.blockFramedPanel.get())), UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)FBContent.blockFramedPanel.get()))});
        } else {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)be.m_58900_().m_60734_()))});
        }
        if (!be.getCamoState().m_60795_()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)be.getCamoStack().m_41777_())});
        }
        if (be instanceof FramedDoubleBlockEntity && !(dbe = (FramedDoubleBlockEntity)be).getCamoStateTwo().m_60795_()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)dbe.getCamoStackTwo().m_41777_())});
        }
        if (be.isGlowing()) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)Items.f_42525_))});
        }
        if (be.isIntangible(CollisionContext.m_82749_())) {
            builder.add(new IUniqueObject[]{UniqueItem.ofStack((ItemStack)new ItemStack((ItemLike)ServerConfig.intangibleMarkerItem))});
        }
        return builder.build();
    }
}

