/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ConfigHandler {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final Server SERVER;

    static {
        Pair clientSpecPair = new ForgeConfigSpec.Builder().configure(Client::new);
        Pair serverSpecPair = new ForgeConfigSpec.Builder().configure(Server::new);
        CLIENT_SPEC = (ForgeConfigSpec)clientSpecPair.getRight();
        CLIENT = (Client)clientSpecPair.getLeft();
        SERVER_SPEC = (ForgeConfigSpec)serverSpecPair.getRight();
        SERVER = (Server)serverSpecPair.getLeft();
    }

    public static class Client {
        public ForgeConfigSpec.BooleanValue sayThanksMessage;
        public ForgeConfigSpec.DoubleValue cameraSpeed;
        public ForgeConfigSpec.BooleanValue reinforcedBlockTint;

        Client(ForgeConfigSpec.Builder builder) {
            this.sayThanksMessage = builder.comment("Display a 'tip' message at spawn?").define("sayThanksMessage", true);
            this.cameraSpeed = builder.comment("How fast can you rotate when mounted to a camera and holding W-A-S-D?").defineInRange("cameraSpeed", 2.0, 0.0, Double.MAX_VALUE);
            this.reinforcedBlockTint = builder.comment("Should reinforced blocks' textures be slightly darker than their vanilla counterparts? This setting can be overriden by servers.").define("reinforced_block_tint", true);
        }
    }

    public static class Server {
        public ForgeConfigSpec.DoubleValue codebreakerChance;
        public ForgeConfigSpec.BooleanValue allowAdminTool;
        public ForgeConfigSpec.BooleanValue shouldSpawnFire;
        public ForgeConfigSpec.BooleanValue ableToBreakMines;
        public ForgeConfigSpec.BooleanValue smallerMineExplosion;
        public ForgeConfigSpec.BooleanValue mineExplodesWhenInCreative;
        public ForgeConfigSpec.BooleanValue mineExplosionsBreakBlocks;
        public ForgeConfigSpec.IntValue laserBlockRange;
        public ForgeConfigSpec.IntValue inventoryScannerRange;
        public ForgeConfigSpec.IntValue maxAlarmRange;
        public ForgeConfigSpec.BooleanValue allowBlockClaim;
        public ForgeConfigSpec.BooleanValue respectInvisibility;
        public ForgeConfigSpec.BooleanValue reinforcedBlockTint;
        public ForgeConfigSpec.BooleanValue forceReinforcedBlockTint;
        public ForgeConfigSpec.BooleanValue retinalScannerFace;
        public ForgeConfigSpec.BooleanValue enableTeamOwnership;
        public ForgeConfigSpec.BooleanValue disableThanksMessage;
        public ForgeConfigSpec.BooleanValue trickScannersWithPlayerHeads;

        Server(ForgeConfigSpec.Builder builder) {
            this.codebreakerChance = builder.comment(new String[]{"The chance for the codebreaker to successfully hack a block. 0.33 is 33%. Set to a negative value to disable the codebreaker.", "Using the codebreaker when this is set to 0.0 will still damage the item, while negative values do not damage it."}).defineInRange("codebreaker_chance", 0.33, -1.0, 1.0);
            this.allowAdminTool = builder.comment("Can the admin tool be used?").define("allowAdminTool", true);
            this.shouldSpawnFire = builder.comment("Should mines spawn fire after exploding?").define("shouldSpawnFire", true);
            this.ableToBreakMines = builder.comment("Should players be able to break a mine without it exploding?").define("ableToBreakMines", true);
            this.smallerMineExplosion = builder.comment("Should mines' explosions be smaller than usual.").define("smallerMineExplosion", false);
            this.mineExplodesWhenInCreative = builder.comment("Should mines explode if broken while in Creative mode?").define("mineExplodesWhenInCreative", true);
            this.mineExplosionsBreakBlocks = builder.comment("Set this to false if you want mines to not break blocks when they explode.").define("mineExplosionsBreakBlocks", true);
            this.laserBlockRange = builder.comment("From how many blocks away can a laser block connect to another laser block?").defineInRange("laserBlockRange", 5, 0, Integer.MAX_VALUE);
            this.inventoryScannerRange = builder.comment("From how many blocks away can an inventory scanner connect to another inventory scanner?").defineInRange("inventoryScannerRange", 2, 0, Integer.MAX_VALUE);
            this.maxAlarmRange = builder.comment("What is the maximum value that can be set for an alarm's range option? Do note, that this may be limited by chunk loading distance. Higher values may also not be finetuneable.").defineInRange("maxAlarmRange", 100, 1, Integer.MAX_VALUE);
            this.allowBlockClaim = builder.comment("Allow claiming unowned blocks?").define("allowBlockClaim", false);
            this.respectInvisibility = builder.comment("Should the sentry/inventory scanner/laser block/etc. ignore players and entities that are invisible?").define("respect_invisibility", false);
            this.reinforcedBlockTint = builder.comment("Should reinforced blocks' textures be slightly darker than their vanilla counterparts? This does nothing unless force_reinforced_block_tint is set to true.").define("reinforced_block_tint", true);
            this.forceReinforcedBlockTint = builder.comment("Set this to true if you want to force the setting of reinforced_block_tint for players.").define("force_reinforced_block_tint", false);
            this.retinalScannerFace = builder.comment("Display owner face on retinal scanner?").define("retinalScannerFace", true);
            this.enableTeamOwnership = builder.comment(new String[]{"Set this to true to enable every player on a scoreboard team to own the blocks of every other player on the same team.", "This enables players on the same team to break each other's reinforced blocks, change options, add/remove modules, and have access to all other owner-restricted things."}).define("enable_team_ownership", false);
            this.disableThanksMessage = builder.comment(new String[]{"Set this to true to disable sending the message that SecurityCraft shows when a player joins.", "Note, that this stops showing the message for every player, even those that want to see them."}).define("disable_thanks_message", false);
            this.trickScannersWithPlayerHeads = builder.comment("Set this to true if you want players wearing a different player's skull to be able to trick their retinal scanners and scanner doors into activating.").define("trick_scanners_with_player_heads", false);
        }
    }
}

