/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.SecurityCraft;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.KeypadDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.network.client.OpenScreen;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.PacketDistributor;

public class KeypadDoorBlockEntity
extends SpecialDoorBlockEntity
implements IPasswordProtected,
ILockable {
    private String passcode;

    public KeypadDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.KEYPAD_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.passcode != null && !this.passcode.isEmpty()) {
            tag.m_128359_("passcode", this.passcode);
        }
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.passcode = tag.m_128461_("passcode");
    }

    @Override
    public void activate(Player player) {
        Block block;
        if (!this.f_58857_.f_46443_ && (block = this.m_58900_().m_60734_()) instanceof KeypadDoorBlock) {
            KeypadDoorBlock block2 = (KeypadDoorBlock)block;
            block2.activate(this.m_58900_(), this.f_58857_, this.f_58858_, this.getSignalLength());
        }
    }

    @Override
    public void openPasswordGUI(Player player) {
        if (!this.f_58857_.f_46443_) {
            if (this.getPassword() != null) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.CHECK_PASSWORD, this.f_58858_));
            } else if (this.getOwner().isOwner(player)) {
                SecurityCraft.channel.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new OpenScreen(OpenScreen.DataType.SET_PASSWORD, this.f_58858_));
            } else {
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)new TextComponent("SecurityCraft"), (MutableComponent)Utils.localize("messages.securitycraft:passwordProtected.notSetUp", new Object[0]), ChatFormatting.DARK_RED);
            }
        }
    }

    @Override
    public boolean onCodebreakerUsed(BlockState state, Player player) {
        if (!((Boolean)state.m_61143_((Property)DoorBlock.f_52727_)).booleanValue()) {
            this.activate(player);
            return true;
        }
        return false;
    }

    @Override
    public String getPassword() {
        return this.passcode != null && !this.passcode.isEmpty() ? this.passcode : null;
    }

    @Override
    public void setPassword(String password) {
        BlockEntity be = null;
        this.passcode = password;
        if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.LOWER) {
            be = this.f_58857_.m_7702_(this.f_58858_.m_7494_());
        } else if (this.m_58900_().m_61143_((Property)DoorBlock.f_52730_) == DoubleBlockHalf.UPPER) {
            be = this.f_58857_.m_7702_(this.f_58858_.m_7495_());
        }
        if (be instanceof KeypadDoorBlockEntity) {
            KeypadDoorBlockEntity doorTe = (KeypadDoorBlockEntity)be;
            doorTe.setPasswordExclusively(password);
        }
        this.m_6596_();
    }

    public void setPasswordExclusively(String password) {
        this.passcode = password;
        this.m_6596_();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST, ModuleType.DENYLIST};
    }

    @Override
    public int defaultSignalLength() {
        return 60;
    }
}

