/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blockentities;

import net.geforcemods.securitycraft.ConfigHandler;
import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.ILockable;
import net.geforcemods.securitycraft.api.IModuleInventory;
import net.geforcemods.securitycraft.api.IViewActivated;
import net.geforcemods.securitycraft.api.Owner;
import net.geforcemods.securitycraft.blockentities.SpecialDoorBlockEntity;
import net.geforcemods.securitycraft.blocks.ScannerDoorBlock;
import net.geforcemods.securitycraft.misc.ModuleType;
import net.geforcemods.securitycraft.util.EntityUtils;
import net.geforcemods.securitycraft.util.ITickingBlockEntity;
import net.geforcemods.securitycraft.util.ModuleUtils;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class ScannerDoorBlockEntity
extends SpecialDoorBlockEntity
implements IViewActivated,
ITickingBlockEntity,
ILockable {
    private int viewCooldown = 0;

    public ScannerDoorBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)SCContent.SCANNER_DOOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state) {
        this.checkView(level, pos);
    }

    @Override
    public boolean onEntityViewed(LivingEntity entity, BlockHitResult hitResult) {
        block9: {
            Player player;
            BlockState lowerState;
            BlockState upperState;
            block11: {
                block10: {
                    upperState = this.f_58857_.m_8055_(this.f_58858_);
                    lowerState = this.f_58857_.m_8055_(this.f_58858_.m_7495_());
                    Direction.Axis facingAxis = ScannerDoorBlock.getFacingAxis(upperState);
                    if (upperState.m_61143_((Property)DoorBlock.f_52730_) != DoubleBlockHalf.UPPER || EntityUtils.isInvisible(entity)) break block9;
                    if (!(entity instanceof Player)) break block10;
                    player = (Player)entity;
                    if (facingAxis == hitResult.m_82434_().m_122434_()) break block11;
                }
                return false;
            }
            if (!this.isLocked()) {
                Owner viewingPlayer = new Owner(player);
                if (((Boolean)ConfigHandler.SERVER.trickScannersWithPlayerHeads.get()).booleanValue() && player.m_6844_(EquipmentSlot.HEAD).m_41720_() == Items.f_42680_) {
                    viewingPlayer = PlayerUtils.getSkullOwner(player);
                }
                if (!this.getOwner().isOwner(viewingPlayer) && !ModuleUtils.isAllowed((IModuleInventory)this, viewingPlayer.getName())) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:retinalScanner.notOwner", PlayerUtils.getOwnerComponent(this.getOwner().getName())), ChatFormatting.RED);
                    return true;
                }
                boolean open = (Boolean)lowerState.m_61143_((Property)DoorBlock.f_52727_) == false;
                int length = this.getSignalLength();
                this.f_58857_.m_7731_(this.f_58858_, (BlockState)upperState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)upperState.m_61143_((Property)DoorBlock.f_52727_) == false)), 3);
                this.f_58857_.m_7731_(this.f_58858_.m_7495_(), (BlockState)lowerState.m_61124_((Property)DoorBlock.f_52727_, (Comparable)Boolean.valueOf((Boolean)lowerState.m_61143_((Property)DoorBlock.f_52727_) == false)), 3);
                this.f_58857_.m_5898_(null, open ? 1005 : 1011, this.f_58858_, 0);
                if (open && length > 0) {
                    this.f_58857_.m_186460_(this.f_58858_, (Block)SCContent.SCANNER_DOOR.get(), length);
                }
                if (open && this.sendsMessages()) {
                    PlayerUtils.sendMessageToPlayer(player, (MutableComponent)Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).m_5524_(), new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:retinalScanner.hello", viewingPlayer.getName()), ChatFormatting.GREEN);
                }
                return true;
            }
            if (this.sendsMessages()) {
                TranslatableComponent blockName = Utils.localize(((Item)SCContent.SCANNER_DOOR_ITEM.get()).m_5524_(), new Object[0]);
                PlayerUtils.sendMessageToPlayer(player, (MutableComponent)blockName, (MutableComponent)Utils.localize("messages.securitycraft:sonic_security_system.locked", blockName), ChatFormatting.DARK_RED, false);
                return true;
            }
        }
        return false;
    }

    @Override
    public int getViewCooldown() {
        return this.viewCooldown;
    }

    @Override
    public void setViewCooldown(int viewCooldown) {
        this.viewCooldown = viewCooldown;
        this.m_6596_();
    }

    @Override
    public ModuleType[] acceptedModules() {
        return new ModuleType[]{ModuleType.ALLOWLIST};
    }

    @Override
    public int defaultSignalLength() {
        return 0;
    }
}

