/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.blocks.reinforced;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.blocks.reinforced.BaseReinforcedBlock;
import net.geforcemods.securitycraft.util.PlayerUtils;
import net.geforcemods.securitycraft.util.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ReinforcedSlabBlock
extends BaseReinforcedBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<SlabType> TYPE = BlockStateProperties.f_61397_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape BOTTOM_SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    protected static final VoxelShape TOP_SHAPE = Block.m_49796_((double)0.0, (double)8.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ReinforcedSlabBlock(BlockBehaviour.Properties properties, Block vB) {
        this(properties, () -> vB);
    }

    public ReinforcedSlabBlock(BlockBehaviour.Properties properties, Supplier<Block> vB) {
        super(properties, vB);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public boolean m_7923_(BlockState state) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{TYPE, WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch ((SlabType)state.m_61143_(TYPE)) {
            case SlabType.DOUBLE -> Shapes.m_83144_();
            case SlabType.TOP -> TOP_SHAPE;
            default -> BOTTOM_SHAPE;
        };
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        BlockState state = level.m_8055_(pos);
        BlockEntity be = level.m_7702_(pos);
        if (state.m_60734_() == this) {
            IOwnable ownable;
            if (be instanceof IOwnable && !(ownable = (IOwnable)be).getOwner().isOwner(ctx.m_43723_())) {
                PlayerUtils.sendMessageToPlayer(ctx.m_43723_(), (MutableComponent)Utils.localize("messages.securitycraft:reinforcedSlab", new Object[0]), (MutableComponent)Utils.localize("messages.securitycraft:reinforcedSlab.cannotDoubleSlab", new Object[0]), ChatFormatting.RED);
                return state;
            }
            return (BlockState)((BlockState)state.m_61124_(TYPE, (Comparable)SlabType.DOUBLE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false));
        }
        FluidState fluidState = ctx.m_43725_().m_6425_(pos);
        BlockState stateToSet = (BlockState)((BlockState)this.m_49966_().m_61124_(TYPE, (Comparable)SlabType.BOTTOM)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidState.m_76152_() == Fluids.f_76193_));
        Direction dir = ctx.m_43719_();
        return !(dir == Direction.DOWN || dir != Direction.UP && ctx.m_43720_().f_82480_ - (double)pos.m_123342_() > 0.5) ? stateToSet : (BlockState)stateToSet.m_61124_(TYPE, (Comparable)SlabType.TOP);
    }

    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        ItemStack stack = ctx.m_43722_();
        SlabType type = (SlabType)state.m_61143_(TYPE);
        if (type != SlabType.DOUBLE && stack.m_41720_() == this.m_5456_()) {
            if (ctx.m_7058_()) {
                boolean clickedUpperHalf = ctx.m_43720_().f_82480_ - (double)ctx.m_8083_().m_123342_() > 0.5;
                Direction dir = ctx.m_43719_();
                if (type == SlabType.BOTTOM) {
                    return dir == Direction.UP || clickedUpperHalf && dir.m_122434_().m_122479_();
                }
                return dir == Direction.DOWN || !clickedUpperHalf && dir.m_122434_().m_122479_();
            }
            return true;
        }
        return false;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7361_(LevelAccessor level, BlockPos pos, BlockState state, FluidState fluidState) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE ? super.m_7361_(level, pos, state, fluidState) : false;
    }

    public boolean m_6044_(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        return state.m_61143_(TYPE) != SlabType.DOUBLE ? super.m_6044_(level, pos, state, fluid) : false;
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND -> false;
            case PathComputationType.WATER -> level.m_6425_(pos).m_205070_(FluidTags.f_13131_);
            case PathComputationType.AIR -> false;
            default -> false;
        };
    }
}

