/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.network.client;

import java.util.function.Supplier;
import net.geforcemods.securitycraft.ClientHandler;
import net.geforcemods.securitycraft.api.IPasswordProtected;
import net.geforcemods.securitycraft.blockentities.IMSBlockEntity;
import net.geforcemods.securitycraft.blockentities.SonicSecuritySystemBlockEntity;
import net.geforcemods.securitycraft.blockentities.TrophySystemBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class OpenScreen {
    private DataType dataType;
    private BlockPos pos;

    public OpenScreen() {
    }

    public OpenScreen(DataType dataType, BlockPos pos) {
        this.dataType = dataType;
        this.pos = pos;
    }

    public static void encode(OpenScreen message, FriendlyByteBuf buf) {
        buf.m_130068_((Enum)message.dataType);
        buf.m_130064_(message.pos);
    }

    public static OpenScreen decode(FriendlyByteBuf buf) {
        DataType dataType = (DataType)buf.m_130066_(DataType.class);
        BlockPos pos = buf.m_130135_();
        return new OpenScreen(dataType, pos);
    }

    public static void onMessage(OpenScreen message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            switch (message.dataType) {
                case CHECK_PASSWORD: {
                    BlockEntity patt1484$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                    if (!(patt1484$temp instanceof IPasswordProtected)) break;
                    IPasswordProtected be = (IPasswordProtected)patt1484$temp;
                    ClientHandler.displayCheckPasswordScreen((BlockEntity)be);
                    break;
                }
                case IMS: {
                    BlockEntity patt1683$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                    if (!(patt1683$temp instanceof IMSBlockEntity)) break;
                    IMSBlockEntity ims = (IMSBlockEntity)patt1683$temp;
                    ClientHandler.displayIMSScreen(ims);
                    break;
                }
                case SET_PASSWORD: {
                    BlockEntity patt1865$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                    if (!(patt1865$temp instanceof IPasswordProtected)) break;
                    IPasswordProtected be = (IPasswordProtected)patt1865$temp;
                    ClientHandler.displaySetPasswordScreen((BlockEntity)be);
                    break;
                }
                case SONIC_SECURITY_SYSTEM: {
                    BlockEntity patt2080$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                    if (!(patt2080$temp instanceof SonicSecuritySystemBlockEntity)) break;
                    SonicSecuritySystemBlockEntity sss = (SonicSecuritySystemBlockEntity)patt2080$temp;
                    ClientHandler.displaySonicSecuritySystemScreen(sss);
                    break;
                }
                case TROPHY_SYSTEM: {
                    BlockEntity patt2295$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                    if (!(patt2295$temp instanceof TrophySystemBlockEntity)) break;
                    TrophySystemBlockEntity trophySystem = (TrophySystemBlockEntity)patt2295$temp;
                    ClientHandler.displayTrophySystemScreen(trophySystem);
                    break;
                }
                case UNIVERSAL_KEY_CHANGER: {
                    BlockEntity patt2522$temp = Minecraft.m_91087_().f_91073_.m_7702_(message.pos);
                    if (!(patt2522$temp instanceof IPasswordProtected)) break;
                    IPasswordProtected passwordProtected = (IPasswordProtected)patt2522$temp;
                    ClientHandler.displayUniversalKeyChangerScreen((BlockEntity)passwordProtected);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    public static enum DataType {
        CHECK_PASSWORD,
        IMS,
        SET_PASSWORD,
        SONIC_SECURITY_SYSTEM,
        TROPHY_SYSTEM,
        UNIVERSAL_KEY_CHANGER;

    }
}

