/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.util;

import com.google.gson.JsonElement;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import snownee.kiwi.block.def.BlockDefinition;
import snownee.kiwi.loader.Platform;
import snownee.kiwi.util.NBTHelper;

public final class Util {
    private static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("###,###");
    public static final MessageFormat MESSAGE_FORMAT = new MessageFormat("{0,number,#.#}");
    public static RecipeManager recipeManager;

    private Util() {
    }

    public static String color(int color) {
        return String.format("\u00a7x%06x", color & 0xFFFFFF);
    }

    public static String formatComma(long number) {
        return DECIMAL_FORMAT.format(number);
    }

    public static String formatCompact(long number) {
        int unit = 1000;
        if (number < (long)unit) {
            return Long.toString(number);
        }
        int exp = (int)(Math.log(number) / Math.log(unit));
        if (exp - 1 >= 0 && exp - 1 < 6) {
            char pre = "kMGTPE".charAt(exp - 1);
            return MESSAGE_FORMAT.format(new Double[]{(double)number / Math.pow(unit, exp)}) + pre;
        }
        return Long.toString(number);
    }

    public static String trimRL(ResourceLocation rl) {
        return Util.trimRL(rl, "minecraft");
    }

    public static String trimRL(String rl) {
        return Util.trimRL(rl, "minecraft");
    }

    public static String trimRL(ResourceLocation rl, String defaultNamespace) {
        return rl.m_135827_().equals(defaultNamespace) ? rl.m_135815_() : rl.toString();
    }

    public static String trimRL(String rl, String defaultNamespace) {
        if (rl.startsWith(defaultNamespace + ":")) {
            return rl.substring(defaultNamespace.length() + 1);
        }
        return rl;
    }

    @Nullable
    public static ResourceLocation RL(@Nullable String string) {
        try {
            return ResourceLocation.m_135820_((String)string);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static ResourceLocation RL(@Nullable String string, String defaultNamespace) {
        if (string != null && !((String)string).contains(":")) {
            string = defaultNamespace + ":" + (String)string;
        }
        return Util.RL((String)string);
    }

    @Nullable
    public static Component getBlockDefName(ItemStack stack, String key) {
        BlockDefinition def;
        NBTHelper data = NBTHelper.of(stack);
        CompoundTag tag = data.getTag("BlockEntityTag.Overrides." + key);
        if (tag != null && (def = BlockDefinition.fromNBT(tag)) != null) {
            return def.getDescription();
        }
        return null;
    }

    @Nullable
    public static RecipeManager getRecipeManager() {
        ClientPacketListener connection;
        if (recipeManager != null) {
            return recipeManager;
        }
        if (Platform.isPhysicalClient() && (connection = Minecraft.m_91087_().m_91403_()) != null) {
            return connection.m_105141_();
        }
        return null;
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getRecipes(RecipeType<T> recipeTypeIn) {
        RecipeManager manager = Util.getRecipeManager();
        if (manager == null) {
            return Collections.EMPTY_LIST;
        }
        return Util.getRecipeManager().m_44013_(recipeTypeIn);
    }

    public static int friendlyCompare(String a, String b) {
        int aLength = a.length();
        int bLength = b.length();
        int minSize = Math.min(aLength, bLength);
        boolean asNumeric = false;
        int lastNumericCompare = 0;
        for (int i = 0; i < minSize; ++i) {
            boolean bNumber;
            char aChar = a.charAt(i);
            char bChar = b.charAt(i);
            boolean aNumber = aChar >= '0' && aChar <= '9';
            boolean bl = bNumber = bChar >= '0' && bChar <= '9';
            if (asNumeric) {
                if (aNumber && bNumber) {
                    if (lastNumericCompare != 0) continue;
                    lastNumericCompare = aChar - bChar;
                    continue;
                }
                if (aNumber) {
                    return 1;
                }
                if (bNumber) {
                    return -1;
                }
                if (lastNumericCompare == 0) {
                    if (aChar != bChar) {
                        return aChar - bChar;
                    }
                    asNumeric = false;
                    continue;
                }
                return lastNumericCompare;
            }
            if (aNumber && bNumber) {
                asNumeric = true;
                if (lastNumericCompare != 0) continue;
                lastNumericCompare = aChar - bChar;
                continue;
            }
            if (aChar == bChar) continue;
            return aChar - bChar;
        }
        if (asNumeric) {
            if (aLength > bLength && a.charAt(bLength) >= '0' && a.charAt(bLength) <= '9') {
                return 1;
            }
            if (bLength > aLength && b.charAt(aLength) >= '0' && b.charAt(aLength) <= '9') {
                return -1;
            }
            if (lastNumericCompare == 0) {
                return aLength - bLength;
            }
            return lastNumericCompare;
        }
        return aLength - bLength;
    }

    public static boolean canPlayerBreak(Player player, BlockState state, BlockPos pos) {
        if (!player.m_36326_() || !player.f_19853_.m_7966_(player, pos)) {
            return false;
        }
        if (!player.m_7500_() && state.m_60625_(player, (BlockGetter)player.f_19853_, pos) <= 0.0f) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(player.f_19853_, pos, state, player);
        return !MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public static int applyAlpha(int color, float alpha) {
        int alphaChannel;
        int prevAlphaChannel = color >> 24 & 0xFF;
        if (prevAlphaChannel > 0) {
            alpha *= (float)prevAlphaChannel / 256.0f;
        }
        if ((alphaChannel = (int)(255.0f * Mth.m_14036_((float)alpha, (float)0.0f, (float)1.0f))) < 5) {
            return 0;
        }
        return color & 0xFFFFFF | alphaChannel << 24;
    }

    public static float getPickRange(Player player) {
        float attrib = (float)player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        return player.m_7500_() ? attrib : attrib - 0.5f;
    }

    public static void displayClientMessage(@Nullable Player player, boolean client, String key, Object ... args) {
        if (player == null) {
            return;
        }
        if (client != player.f_19853_.f_46443_) {
            return;
        }
        player.m_5661_((Component)new TranslatableComponent(key, args), true);
    }

    public static void jsonList(JsonElement json, Consumer<JsonElement> collector) {
        if (json.isJsonArray()) {
            for (JsonElement e : json.getAsJsonArray()) {
                collector.accept(e);
            }
        } else {
            collector.accept(json);
        }
    }

    @Nullable
    public static String[] readNBTStrings(CompoundTag tag, String key, @Nullable String[] strings) {
        if (!tag.m_128425_(key, 9)) {
            return null;
        }
        ListTag list = tag.m_128437_(key, 8);
        if (list.isEmpty()) {
            return null;
        }
        if (strings == null || strings.length != list.size()) {
            strings = new String[list.size()];
        }
        for (int i = 0; i < strings.length; ++i) {
            String s;
            strings[i] = s = list.m_128778_(i);
        }
        return strings;
    }

    public static void writeNBTStrings(CompoundTag tag, String key, @Nullable String[] strings) {
        if (strings == null || strings.length == 0) {
            return;
        }
        ListTag list = new ListTag();
        for (String s : strings) {
            list.add((Object)StringTag.m_129297_((String)s));
        }
        tag.m_128365_(key, (Tag)list);
    }
}

