/*
 * Decompiled with CFR 0.152.
 */
package com.zainjx.the_wild_update;

import com.google.common.collect.ImmutableMap;
import com.zainjx.the_wild_update.enchantments.ModEnchantments;
import com.zainjx.the_wild_update.entity.ModEntityTypes;
import com.zainjx.the_wild_update.entity.render.AcaciaChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.BirchChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.DarkOakChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.DetectRenderer;
import com.zainjx.the_wild_update.entity.render.FrogRenderer;
import com.zainjx.the_wild_update.entity.render.JungleChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.MangroveChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.ModBoatRenderer;
import com.zainjx.the_wild_update.entity.render.OakChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.SpruceChestBoatRenderer;
import com.zainjx.the_wild_update.entity.render.TadpoleRenderer;
import com.zainjx.the_wild_update.entity.render.VibrationRenderer;
import com.zainjx.the_wild_update.entity.render.WardenRenderer;
import com.zainjx.the_wild_update.events.ModEventBusEvents;
import com.zainjx.the_wild_update.gui.container.ModContainers;
import com.zainjx.the_wild_update.gui.screen.ChestBoatScreen;
import com.zainjx.the_wild_update.registry.ParticleList;
import com.zainjx.the_wild_update.registry.RegistryBlocks;
import com.zainjx.the_wild_update.registry.RegistryDeepdarkBlocks;
import com.zainjx.the_wild_update.registry.RegistryEffects;
import com.zainjx.the_wild_update.registry.RegistryItems;
import com.zainjx.the_wild_update.registry.RegistryMangrove;
import com.zainjx.the_wild_update.registry.RegistryMud;
import com.zainjx.the_wild_update.registry.RegistrySounds;
import com.zainjx.the_wild_update.tileentity.ModTileEntities;
import com.zainjx.the_wild_update.world.biome.ModBiomes;
import com.zainjx.the_wild_update.world.gen.ModBiomeGeneration;
import java.util.stream.Collectors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="the_wild_update")
public class TheWildUpdateMod {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "the_wild_update";

    public TheWildUpdateMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuffs);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(ModEventBusEvents::addEntityAttributes);
        ParticleList.PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)this);
        RegistryMangrove.init();
        RegistryMud.init();
        RegistryBlocks.init();
        RegistryDeepdarkBlocks.init();
        RegistryItems.init();
        RegistryEffects.init();
        RegistrySounds.init();
        ModEntityTypes.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModTileEntities.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModContainers.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBiomes.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModEnchantments.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    private void setup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            AxeItem.f_150683_ = new ImmutableMap.Builder().putAll(AxeItem.f_150683_).put((Object)((Block)RegistryMangrove.MANGROVE_LOG.get()), (Object)((Block)RegistryMangrove.MANGROVE_STRIPPED_LOG.get())).build();
            ModBiomeGeneration.generateBiomes();
        });
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.FROG.get()), FrogRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.TADPOLE.get()), TadpoleRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.WARDEN.get()), WardenRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.VIBRATION_ENTITY.get()), VibrationRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.DETECT.get()), DetectRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.MANGROVE_BOAT.get()), ModBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.MANGROVE_CHEST_BOAT.get()), MangroveChestBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.OAK_CHEST_BOAT.get()), OakChestBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.ACACIA_CHEST_BOAT.get()), AcaciaChestBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.BIRCH_CHEST_BOAT.get()), BirchChestBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.DARK_OAK_CHEST_BOAT.get()), DarkOakChestBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.JUNGLE_CHEST_BOAT.get()), JungleChestBoatRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)ModEntityTypes.SPRUCE_CHEST_BOAT.get()), SpruceChestBoatRenderer::new);
    }

    private void doClientStuffs(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMangrove.MANGROVE_DOOR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMangrove.MANGROVE_TRAPDOOR.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMangrove.MANGROVE_PROPAGULE.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryDeepdarkBlocks.SCULK_VEIN.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryMud.TADPOLE_EGGS.get()), (RenderType)RenderType.m_110463_());
            ItemBlockRenderTypes.setRenderLayer((Block)((Block)RegistryDeepdarkBlocks.SCULK_SHRIEKER.get()), (RenderType)RenderType.m_110463_());
            MenuScreens.m_96206_((MenuType)((MenuType)ModContainers.CHEST_BOAT_CONTAINER.get()), ChestBoatScreen::new);
        });
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)MOD_ID, (String)"helloworld", () -> {
            LOGGER.info("Hello world from the MDK");
            return "Hello world";
        });
    }

    private void processIMC(InterModProcessEvent event) {
        LOGGER.info("Got IMC {}", event.getIMCStream().map(m -> m.messageSupplier().get()).collect(Collectors.toList()));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
    public static class RegistryEvents {
        @SubscribeEvent
        public static void onBlocksRegistry(RegistryEvent.Register<Block> blockRegistryEvent) {
            LOGGER.info("HELLO from Register Block");
        }

        @SubscribeEvent
        public static void registerBlockColors(ColorHandlerEvent.Block event) {
            event.getBlockColors().m_92589_((p_92567_, p_92568_, p_92569_, p_92570_) -> p_92568_ != null && p_92569_ != null ? BiomeColors.m_108804_((BlockAndTintGetter)p_92568_, (BlockPos)p_92569_) : FoliageColor.m_46113_(), new Block[]{(Block)RegistryMangrove.MANGROVE_LEAVES.get()});
        }

        @SubscribeEvent
        public static void registerItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().m_92689_((p_92672_, p_92673_) -> FoliageColor.m_46113_(), new ItemLike[]{(ItemLike)RegistryMangrove.MANGROVE_LEAVES.get()});
        }
    }
}

