/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.client;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import doggytalents.DoggyTalents2;
import doggytalents.client.CachedFileTexture;
import doggytalents.client.SkinRequest;
import doggytalents.common.entity.DogEntity;
import doggytalents.common.entity.texture.DogTextureServer;
import doggytalents.common.lib.Resources;
import doggytalents.common.util.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

public class DogTextureManager
extends SimplePreparableReloadListener<Preparations> {
    public static final DogTextureManager INSTANCE = new DogTextureManager();
    private static final Gson GSON = new Gson();
    private static final ResourceLocation OVERRIDE_RESOURCE_LOCATION = Util.getResource("textures/entity/dog/custom/overrides.json");
    private final Map<String, SkinRequest> hashToSkinRequest = Maps.newConcurrentMap();
    protected final Map<String, ResourceLocation> skinHashToLoc = Maps.newHashMap();
    protected final Map<ResourceLocation, String> locToSkinHash = Maps.newHashMap();
    protected final List<ResourceLocation> customSkinLoc = new ArrayList<ResourceLocation>(20);

    public SkinRequest getRequestStatus(String hash) {
        return this.hashToSkinRequest.getOrDefault(hash, SkinRequest.UNREQUESTED);
    }

    public void setRequestHandled(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.RECEIVED);
    }

    public void setRequestFailed(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.FAILED);
    }

    public void setRequested(String hash) {
        this.hashToSkinRequest.put(hash, SkinRequest.REQUESTED);
    }

    public List<ResourceLocation> getAll() {
        return Collections.unmodifiableList(this.customSkinLoc);
    }

    public ResourceLocation getLocFromHashOrGet(String hash, Function<? super String, ? extends ResourceLocation> mappingFunction) {
        return this.skinHashToLoc.computeIfAbsent(hash, mappingFunction);
    }

    public String getTextureHash(ResourceLocation loc) {
        return this.locToSkinHash.getOrDefault(loc, "MISSING_MAPPING");
    }

    public ResourceLocation getTextureLoc(String loc) {
        return this.skinHashToLoc.getOrDefault(loc, null);
    }

    public File getClientFolder() {
        Minecraft mc = Minecraft.m_91087_();
        SkinManager skinManager = mc.m_91109_();
        return new File(skinManager.f_118808_.getParentFile(), "skins_dog");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getResourceBytes(ResourceLocation loc) throws IOException {
        InputStream stream = null;
        try {
            stream = this.getResourceStream(loc);
            byte[] byArray = IOUtils.toByteArray((InputStream)stream);
            return byArray;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }

    @Nullable
    public InputStream getResourceStream(ResourceLocation loc) throws IOException {
        Minecraft mc = Minecraft.m_91087_();
        ResourceManager resourceManager = mc.m_91098_();
        Resource resource = resourceManager.m_142591_(loc);
        return resource.m_6679_();
    }

    public ResourceLocation getTexture(DogEntity dog) {
        if (dog.hasCustomSkin()) {
            String hash = dog.getSkinHash();
            return INSTANCE.getLocFromHashOrGet(hash, this::getCached);
        }
        return Resources.ENTITY_WOLF;
    }

    public AbstractTexture getOrLoadTexture(File baseFolder, String hash) {
        Minecraft mc = Minecraft.m_91087_();
        TextureManager textureManager = mc.m_91097_();
        File cacheFile = DogTextureServer.INSTANCE.getCacheFile(baseFolder, hash);
        ResourceLocation loc = DogTextureServer.INSTANCE.getResourceLocation(hash);
        Object texture = textureManager.m_118506_(loc);
        if (texture == null && cacheFile.isFile() && cacheFile.exists()) {
            texture = new CachedFileTexture(loc, cacheFile);
            textureManager.m_118495_(loc, texture);
        }
        return texture;
    }

    public String saveTextureAndLoad(File baseFolder, byte[] data) throws IOException {
        Minecraft mc = Minecraft.m_91087_();
        TextureManager textureManager = mc.m_91097_();
        String hash = DogTextureServer.INSTANCE.getHash(data);
        File cacheFile = DogTextureServer.INSTANCE.getCacheFile(baseFolder, hash);
        ResourceLocation loc = DogTextureServer.INSTANCE.getResourceLocation(hash);
        AbstractTexture texture = textureManager.m_118506_(loc);
        if (texture == null) {
            DoggyTalents2.LOGGER.debug("Saved dog texture to local cache ({})", (Object)cacheFile);
            FileUtils.writeByteArrayToFile((File)cacheFile, (byte[])data);
            DoggyTalents2.LOGGER.debug("Texture not current loaded trying to load");
            textureManager.m_118495_(loc, (AbstractTexture)new CachedFileTexture(loc, cacheFile));
        }
        return hash;
    }

    public ResourceLocation getCached(String hash) {
        return Resources.ENTITY_WOLF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadDogSkinResource(Preparations prep, Resource resource) {
        InputStream inputstream = null;
        try {
            inputstream = resource.m_6679_();
            String hash = DogTextureServer.INSTANCE.getHash(IOUtils.toByteArray((InputStream)inputstream));
            ResourceLocation rl = resource.m_7843_();
            if (prep.skinHashToLoc.containsKey(hash)) {
                DoggyTalents2.LOGGER.warn("The loaded resource packs contained a duplicate custom dog skin ({} & {})", (Object)resource.m_7843_(), (Object)this.skinHashToLoc.get(hash));
            } else {
                DoggyTalents2.LOGGER.info("Found custom dog skin at {} with hash {}", (Object)rl, (Object)hash);
                prep.skinHashToLoc.put(hash, rl);
                prep.locToSkinHash.put(rl, hash);
                prep.customSkinLoc.add(rl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputstream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadOverrideData(Preparations prep, List<Resource> resourcesList) {
        for (Resource iresource : resourcesList) {
            InputStream inputstream = iresource.m_6679_();
            DoggyTalents2.LOGGER.debug("Loading {}", (Object)iresource);
            try {
                this.loadLocaleData(prep, inputstream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputstream);
            }
        }
    }

    private synchronized void loadLocaleData(Preparations prep, InputStream inputStreamIn) {
        JsonElement jsonelement = (JsonElement)GSON.fromJson((Reader)new InputStreamReader(inputStreamIn, StandardCharsets.UTF_8), JsonElement.class);
        JsonObject jsonobject = GsonHelper.m_13918_((JsonElement)jsonelement, (String)"strings");
        for (Map.Entry entry : jsonobject.entrySet()) {
            ResourceLocation texture;
            String hash = (String)entry.getKey();
            ResourceLocation previous = prep.skinHashToLoc.put(hash, texture = new ResourceLocation(GsonHelper.m_13805_((JsonElement)((JsonElement)entry.getValue()), (String)hash)));
            if (previous != null) {
                // empty if block
            }
            DoggyTalents2.LOGGER.info("Loaded override for {} -> {}", (Object)hash, (Object)texture);
        }
    }

    protected Preparations prepare(ResourceManager resourceManager, ProfilerFiller profiler) {
        Preparations prep = new Preparations();
        profiler.m_7242_();
        Collection resources = resourceManager.m_6540_("textures/entity/dog/custom", fileName -> fileName.endsWith(".png"));
        for (ResourceLocation rl : resources) {
            try {
                Resource resource = resourceManager.m_142591_(rl);
                if (resource == null) {
                    DoggyTalents2.LOGGER.warn("Could not get resource");
                    continue;
                }
                this.loadDogSkinResource(prep, resource);
            }
            catch (FileNotFoundException resource) {
            }
            catch (Exception exception) {
                DoggyTalents2.LOGGER.warn("Skipped custom dog skin file: {} ({})", (Object)rl, (Object)exception);
            }
        }
        try {
            List override = resourceManager.m_7396_(OVERRIDE_RESOURCE_LOCATION);
            this.loadOverrideData(prep, override);
        }
        catch (FileNotFoundException override) {
        }
        catch (IOException | RuntimeException runtimeexception) {
            DoggyTalents2.LOGGER.warn("Unable to parse dog skin override data: {}", (Throwable)runtimeexception);
        }
        profiler.m_7238_();
        profiler.m_7241_();
        return prep;
    }

    protected void apply(Preparations prep, ResourceManager resourceManager, ProfilerFiller profiler) {
        prep.apply(this);
    }

    public String m_7812_() {
        return "DogTextureManager";
    }

    protected static class Preparations {
        private final Map<String, ResourceLocation> skinHashToLoc = new HashMap<String, ResourceLocation>();
        private final Map<ResourceLocation, String> locToSkinHash = new HashMap<ResourceLocation, String>();
        private final List<ResourceLocation> customSkinLoc = new ArrayList<ResourceLocation>(20);

        protected Preparations() {
        }

        public void apply(DogTextureManager dogTextureManager) {
            dogTextureManager.skinHashToLoc.clear();
            dogTextureManager.customSkinLoc.clear();
            dogTextureManager.skinHashToLoc.putAll(this.skinHashToLoc);
            dogTextureManager.locToSkinHash.putAll(this.locToSkinHash);
            dogTextureManager.customSkinLoc.addAll(this.customSkinLoc);
        }
    }
}

