/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.talent;

import doggytalents.api.inferface.AbstractDogEntity;
import doggytalents.api.registry.Talent;
import doggytalents.api.registry.TalentInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;

public class PoisonFangTalent
extends TalentInstance {
    public PoisonFangTalent(Talent talentIn, int levelIn) {
        super(talentIn, levelIn);
    }

    @Override
    public InteractionResult processInteract(AbstractDogEntity dogIn, Level worldIn, Player playerIn, InteractionHand handIn) {
        if (dogIn.m_21824_()) {
            if (this.level() < 5) {
                return InteractionResult.PASS;
            }
            ItemStack stack = playerIn.m_21120_(handIn);
            if (stack.m_41720_() == Items.f_42591_) {
                if (playerIn.m_21124_(MobEffects.f_19614_) == null || dogIn.getDogHunger() < 30.0f) {
                    return InteractionResult.FAIL;
                }
                if (!worldIn.f_46443_) {
                    playerIn.m_21219_();
                    dogIn.setDogHunger(dogIn.getDogHunger() - 30.0f);
                    dogIn.consumeItemFromStack((Entity)playerIn, stack);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult isPotionApplicable(AbstractDogEntity dogIn, MobEffectInstance effectIn) {
        if (this.level() >= 3 && effectIn.m_19544_() == MobEffects.f_19614_) {
            return InteractionResult.FAIL;
        }
        return InteractionResult.PASS;
    }

    @Override
    public InteractionResult attackEntityAsMob(AbstractDogEntity dog, Entity entity) {
        if (entity instanceof LivingEntity && this.level() > 0) {
            ((LivingEntity)entity).m_7292_(new MobEffectInstance(MobEffects.f_19614_, this.level() * 20, 0));
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }
}

