/*
 * Decompiled with CFR 0.152.
 */
package mca.client.render.layer;

import java.util.Optional;
import mca.client.model.VillagerEntityModelMCA;
import mca.client.render.layer.VillagerLayer;
import mca.client.resources.ColorPalette;
import mca.entity.VillagerLike;
import mca.entity.ai.Genetics;
import mca.entity.ai.Traits;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.DyeColor;

public class HairLayer<T extends Mob>
extends VillagerLayer<T, VillagerEntityModelMCA<T>> {
    public HairLayer(RenderLayerParent<T, VillagerEntityModelMCA<T>> renderer, VillagerEntityModelMCA<T> model) {
        super(renderer, model);
        this.model.f_102814_.f_104207_ = false;
        this.model.leftLegwear.f_104207_ = false;
        this.model.f_102813_.f_104207_ = false;
        this.model.rightLegwear.f_104207_ = false;
    }

    @Override
    protected ResourceLocation getSkin(T villager) {
        return this.cached(((VillagerLike)villager).getHair().texture(), ResourceLocation::new);
    }

    @Override
    protected ResourceLocation getOverlay(T villager) {
        return this.cached(((VillagerLike)villager).getHair().overlay(), ResourceLocation::new);
    }

    @Override
    protected float[] getColor(T villager) {
        Optional<DyeColor> hairDye = ((VillagerLike)villager).getHairDye();
        if (hairDye.isPresent()) {
            return hairDye.get().m_41068_();
        }
        float albinism = ((VillagerLike)villager).getTraits().hasTrait(Traits.Trait.ALBINISM) ? 0.1f : 1.0f;
        return ColorPalette.HAIR.getColor(((VillagerLike)villager).getGenetics().getGene(Genetics.EUMELANIN) * albinism, ((VillagerLike)villager).getGenetics().getGene(Genetics.PHEOMELANIN) * albinism, 0.0f);
    }
}

