/*
 * Decompiled with CFR 0.152.
 */
package mca.entity;

import com.google.common.base.Strings;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mca.Config;
import mca.MCA;
import mca.entity.EntitiesMCA;
import mca.entity.Infectable;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.DialogueType;
import mca.entity.ai.Genetics;
import mca.entity.ai.Messenger;
import mca.entity.ai.Traits;
import mca.entity.ai.brain.VillagerBrain;
import mca.entity.ai.relationship.AgeState;
import mca.entity.ai.relationship.EntityRelationship;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.VillagerDimensions;
import mca.entity.ai.relationship.family.FamilyTreeNode;
import mca.entity.interaction.EntityCommandHandler;
import mca.resources.API;
import mca.resources.ClothingList;
import mca.resources.HairList;
import mca.resources.data.Hair;
import mca.server.world.data.PlayerSaveData;
import mca.util.network.datasync.CDataManager;
import mca.util.network.datasync.CDataParameter;
import mca.util.network.datasync.CEnumParameter;
import mca.util.network.datasync.CParameter;
import mca.util.network.datasync.CTrackedEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;

public interface VillagerLike<E extends Entity>
extends CTrackedEntity<E>,
VillagerDataHolder,
Infectable,
Messenger {
    public static final CDataParameter<String> VILLAGER_NAME;
    public static final CDataParameter<String> CUSTOM_SKIN;
    public static final CDataParameter<String> CLOTHES;
    public static final CDataParameter<String> HAIR;
    public static final CDataParameter<String> HAIR_OVERLAY;
    public static final CEnumParameter<DyeColor> HAIR_COLOR;
    public static final CEnumParameter<AgeState> AGE_STATE;
    public static final UUID SPEED_ID;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return new CDataManager.Builder<E>(type).addAll(VILLAGER_NAME, CUSTOM_SKIN, CLOTHES, HAIR, HAIR_OVERLAY, HAIR_COLOR, AGE_STATE).add(Genetics::createTrackedData).add(Traits::createTrackedData).add(VillagerBrain::createTrackedData);
    }

    public Genetics getGenetics();

    public Traits getTraits();

    public VillagerBrain<?> getVillagerBrain();

    public EntityCommandHandler<?> getInteractions();

    default public void initialize(MobSpawnType spawnReason) {
        if (spawnReason != MobSpawnType.CONVERSION) {
            if (spawnReason != MobSpawnType.BREEDING) {
                this.getGenetics().randomize();
                this.getTraits().randomize();
            }
            if (this.getGenetics().getGender() == Gender.UNASSIGNED) {
                this.getGenetics().setGender(Gender.getRandom());
            }
            if (Strings.isNullOrEmpty((String)((String)this.getTrackedValue(VILLAGER_NAME)))) {
                this.setName(API.getVillagePool().pickCitizenName(this.getGenetics().getGender()));
            }
            this.initializeSkin();
            this.getVillagerBrain().randomize();
        }
        this.asEntity().m_6210_();
    }

    @Override
    default public boolean isSpeechImpaired() {
        return this.getInfectionProgress() > 150.0f;
    }

    @Override
    default public boolean isToYoungToSpeak() {
        return this.getAgeState() == AgeState.BABY;
    }

    default public void setName(String name) {
        this.setTrackedValue(VILLAGER_NAME, name);
        EntityRelationship.of((Entity)this.asEntity()).ifPresent(relationship -> relationship.getFamilyEntry().setName(name));
    }

    default public void setCustomSkin(String name) {
        this.setTrackedValue(CUSTOM_SKIN, name);
    }

    default public void updateCustomSkin() {
    }

    default public GameProfile getGameProfile() {
        return null;
    }

    default public boolean hasCustomSkin() {
        if (!((String)this.getTrackedValue(CUSTOM_SKIN)).isEmpty() && this.getGameProfile() != null) {
            Minecraft minecraftClient = Minecraft.m_91087_();
            Map map = minecraftClient.m_91109_().m_118815_(this.getGameProfile());
            return map.containsKey(MinecraftProfileTexture.Type.SKIN);
        }
        return false;
    }

    default public ResourceLocation getProfessionId() {
        return MCA.locate("none");
    }

    default public String getProfessionName() {
        String professionName = (this.getProfessionId().m_135827_().equalsIgnoreCase("minecraft") ? (this.getProfessionId().m_135815_().equals("none") ? "mca.none" : this.getProfessionId().m_135815_()) : this.getProfessionId().toString()).replace(":", ".");
        return professionName.isEmpty() ? "mca.none" : professionName;
    }

    default public String getClothes() {
        return (String)this.getTrackedValue(CLOTHES);
    }

    default public void setClothes(String clothes) {
        this.setTrackedValue(CLOTHES, clothes);
    }

    default public Hair getHair() {
        return new Hair((String)this.getTrackedValue(HAIR), (String)this.getTrackedValue(HAIR_OVERLAY));
    }

    default public void setHair(Hair hair) {
        this.setTrackedValue(HAIR, hair.texture());
        this.setTrackedValue(HAIR_OVERLAY, hair.overlay());
    }

    default public void setHairDye(DyeColor color) {
        this.setTrackedValue(HAIR_COLOR, color);
    }

    default public void clearHairDye() {
        this.setTrackedValue(HAIR_COLOR, null);
    }

    default public Optional<DyeColor> getHairDye() {
        return Optional.ofNullable((DyeColor)this.getTrackedValue(HAIR_COLOR));
    }

    default public AgeState getAgeState() {
        return (AgeState)this.getTrackedValue(AGE_STATE);
    }

    default public VillagerDimensions getVillagerDimensions() {
        return this.getAgeState();
    }

    default public void updateSpeed() {
        float speed = this.getVillagerBrain().getPersonality().getSpeedModifier();
        speed /= 0.9f + this.getGenetics().getGene(Genetics.WIDTH) * 0.2f;
        speed *= 0.9f + this.getGenetics().getGene(Genetics.SIZE) * 0.2f;
        speed *= this.getAgeState().getSpeed();
        AttributeInstance entityAttributeInstance = this.asEntity().m_21051_(Attributes.f_22279_);
        if (entityAttributeInstance != null) {
            if (entityAttributeInstance.m_22111_(SPEED_ID) != null) {
                entityAttributeInstance.m_22120_(SPEED_ID);
            }
            AttributeModifier speedModifier = new AttributeModifier(SPEED_ID, "Speed", (double)(speed - 1.0f), AttributeModifier.Operation.MULTIPLY_BASE);
            entityAttributeInstance.m_22118_(speedModifier);
        }
    }

    default public boolean setAgeState(AgeState state) {
        AgeState old = this.getAgeState();
        if (state == old) {
            return false;
        }
        this.setTrackedValue(AGE_STATE, state);
        this.asEntity().m_6210_();
        this.updateSpeed();
        return old != AgeState.UNASSIGNED;
    }

    default public float getHorizontalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().m_6162_() ? 0.5f : 1.0f;
        }
        return Math.min(0.999f, this.getGenetics().getHorizontalScaleFactor() * this.getTraits().getHorizontalScaleFactor() * this.getVillagerDimensions().getWidth());
    }

    default public float getRawScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().m_6162_() ? 0.5f : 1.0f;
        }
        return this.getGenetics().getVerticalScaleFactor() * this.getTraits().getVerticalScaleFactor() * this.getVillagerDimensions().getHeight() * Config.getInstance().villagerHeight;
    }

    @Override
    default public DialogueType getDialogueType(Player receiver) {
        if (!receiver.f_19853_.f_46443_) {
            Optional<EntityRelationship> r;
            DialogueType type = DialogueType.fromAge(this.getAgeState());
            if (!receiver.f_19853_.f_46443_ && (r = EntityRelationship.of((Entity)this.asEntity())).isPresent()) {
                FamilyTreeNode relationship = r.get().getFamilyEntry();
                if (relationship.spouse().equals(receiver.m_142081_())) {
                    return DialogueType.SPOUSE;
                }
                if (relationship.isParent(receiver.m_142081_())) {
                    return type.toChild();
                }
            }
            this.getVillagerBrain().getMemoriesForPlayer(receiver).setDialogueType(type);
        }
        return this.getVillagerBrain().getMemoriesForPlayer(receiver).getDialogueType();
    }

    default public void initializeSkin() {
        this.randomizeClothes();
        this.setHair(HairList.getInstance().pickOne(this));
    }

    default public void randomizeClothes() {
        this.setClothes(ClothingList.getInstance().getPool(this).pickOne());
    }

    default public CompoundTag toNbtForConversion(EntityType<?> convertingTo) {
        CompoundTag output = new CompoundTag();
        this.getTypeDataManager().save(this.asEntity(), output);
        return output;
    }

    default public void readNbtForConversion(EntityType<?> convertingFrom, CompoundTag input) {
        this.getTypeDataManager().load(this.asEntity(), input);
    }

    default public void copyVillagerAttributesFrom(VillagerLike<?> other) {
        this.readNbtForConversion(other.asEntity().m_6095_(), other.toNbtForConversion(this.asEntity().m_6095_()));
    }

    public static VillagerLike<?> toVillager(Entity entity) {
        if (entity instanceof VillagerLike) {
            return (VillagerLike)entity;
        }
        if (entity instanceof Player) {
            CompoundTag villagerData = PlayerSaveData.get((ServerLevel)entity.f_19853_, entity.m_142081_()).getEntityData();
            VillagerEntityMCA villager = (VillagerEntityMCA)((EntityType)EntitiesMCA.MALE_VILLAGER.get()).m_20615_(entity.f_19853_);
            if (!1.$assertionsDisabled && villager == null) {
                throw new AssertionError();
            }
            villager.m_7378_(villagerData);
            return villager;
        }
        return null;
    }

    default public boolean isHostile() {
        return false;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        VILLAGER_NAME = CParameter.create("villagerName", "");
        CUSTOM_SKIN = CParameter.create("custom_skin", "");
        CLOTHES = CParameter.create("clothes", "");
        HAIR = CParameter.create("hair", "");
        HAIR_OVERLAY = CParameter.create("hairOverlay", "");
        HAIR_COLOR = CParameter.create("hairColor", DyeColor.class);
        AGE_STATE = CParameter.create("ageState", AgeState.UNASSIGNED);
        SPEED_ID = UUID.fromString("1eaf83ff-7207-5596-c37a-d7a07b3ec4ce");
    }
}

