/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai;

import com.google.common.collect.ImmutableSet;
import dev.architectury.registry.registries.DeferredRegister;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.HashSet;
import java.util.Set;
import mca.entity.ai.PointOfInterestTypeMCA;
import mca.mixin.MixinVillagerProfession;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface ProfessionsMCA {
    public static final DeferredRegister<VillagerProfession> PROFESSIONS = DeferredRegister.create((String)"mca", (ResourceKey)Registry.f_122809_);
    public static final RegistrySupplier<VillagerProfession> OUTLAW = ProfessionsMCA.register("outlaw", false, PoiType.f_27331_, SoundEvents.f_12567_);
    public static final RegistrySupplier<VillagerProfession> GUARD = ProfessionsMCA.register("guard", false, PoiType.f_27331_, SoundEvents.f_12510_);
    public static final RegistrySupplier<VillagerProfession> ARCHER = ProfessionsMCA.register("archer", true, PoiType.f_27331_, SoundEvents.f_12569_);
    public static final Set<VillagerProfession> canNotTrade = new HashSet<VillagerProfession>();

    public static void bootstrap() {
        PROFESSIONS.register();
        PointOfInterestTypeMCA.bootstrap();
        canNotTrade.add(VillagerProfession.f_35585_);
        canNotTrade.add(VillagerProfession.f_35596_);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, PoiType workStation, @Nullable SoundEvent workSound) {
        return ProfessionsMCA.register(name, canTradeWith, workStation, (ImmutableSet<Item>)ImmutableSet.of(), (ImmutableSet<Block>)ImmutableSet.of(), workSound);
    }

    public static RegistrySupplier<VillagerProfession> register(String name, boolean canTradeWith, PoiType workStation, ImmutableSet<Item> gatherableItems, ImmutableSet<Block> secondaryJobSites, @Nullable SoundEvent workSound) {
        ResourceLocation id = new ResourceLocation("mca", name);
        return PROFESSIONS.register(id, () -> {
            VillagerProfession result = MixinVillagerProfession.init(id.toString().replace(':', '.'), workStation, gatherableItems, secondaryJobSites, workSound);
            if (!canTradeWith) {
                canNotTrade.add(result);
            }
            return result;
        });
    }

    public static String getFavoredBuilding(VillagerProfession profession) {
        if (VillagerProfession.f_35588_ == profession || VillagerProfession.f_35594_ == profession || VillagerProfession.f_35589_ == profession) {
            return "library";
        }
        if (GUARD.get() == profession || ARCHER.get() == profession) {
            return "inn";
        }
        return null;
    }
}

