/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import mca.Config;
import mca.advancement.criterion.CriterionMCA;
import mca.entity.VillagerLike;
import mca.entity.ai.ActivityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.Memories;
import mca.entity.ai.MemoryModuleTypeMCA;
import mca.entity.ai.Mood;
import mca.entity.ai.MoodGroup;
import mca.entity.ai.MoveState;
import mca.entity.ai.relationship.Personality;
import mca.util.network.datasync.CDataManager;
import mca.util.network.datasync.CDataParameter;
import mca.util.network.datasync.CEnumParameter;
import mca.util.network.datasync.CParameter;
import mca.util.network.datasync.CTrackedEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import org.jetbrains.annotations.Nullable;

public class VillagerBrain<E extends Mob> {
    private static final CDataParameter<CompoundTag> MEMORIES = CParameter.create("memories", new CompoundTag());
    private static final CEnumParameter<Personality> PERSONALITY = CParameter.create("personality", Personality.UNASSIGNED);
    private static final CDataParameter<Integer> MOOD = CParameter.create("mood", 0);
    private static final CEnumParameter<MoveState> MOVE_STATE = CParameter.create("moveState", MoveState.MOVE);
    private static final CEnumParameter<Chore> ACTIVE_CHORE = CParameter.create("activeChore", Chore.NONE);
    private static final CDataParameter<Optional<UUID>> CHORE_ASSIGNING_PLAYER = CParameter.create("choreAssigningPlayer", Optional.empty());
    private static final CDataParameter<Boolean> PANICKING = CParameter.create("isPanicking", false);
    private static final CDataParameter<Boolean> WEAR_ARMOR = CParameter.create("wearArmor", false);
    private final E entity;

    public static <E extends Entity> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(MEMORIES, PERSONALITY, MOOD, MOVE_STATE, ACTIVE_CHORE, CHORE_ASSIGNING_PLAYER, PANICKING, WEAR_ARMOR);
    }

    public VillagerBrain(E entity) {
        this.entity = entity;
    }

    public void think() {
        CompoundTag nbt;
        boolean panicking;
        if (((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE) != Chore.NONE) {
            this.entity.m_6274_().m_21968_().ifPresent(activity -> {
                if (!activity.equals(ActivityMCA.CHORE.get())) {
                    this.entity.m_6274_().m_21889_((Activity)ActivityMCA.CHORE.get());
                }
            });
        }
        if ((panicking = this.entity.m_6274_().m_21954_(Activity.f_37984_)) != (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING)) {
            ((CTrackedEntity)this.entity).setTrackedValue(PANICKING, panicking);
        }
        if (((Mob)this.entity).f_19797_ % 20 != 0) {
            this.updateMoveState();
        }
        if (((Mob)this.entity).f_19797_ % Config.getInstance().interactionFatigueCooldown == 0 && (nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES)) != null) {
            for (String uuid : nbt.m_128431_()) {
                Memories memories = Memories.fromCNBT(this.entity, nbt.m_128469_(uuid));
                int fatigue = memories.getInteractionFatigue();
                if (fatigue <= 0) continue;
                memories.setInteractionFatigue(fatigue - 1);
            }
        }
    }

    public Chore getCurrentJob() {
        return (Chore)((Object)((CTrackedEntity)this.entity).getTrackedValue(ACTIVE_CHORE));
    }

    public Optional<Player> getJobAssigner() {
        return ((Optional)((CTrackedEntity)this.entity).getTrackedValue(CHORE_ASSIGNING_PLAYER)).map(id -> ((Mob)this.entity).f_19853_.m_46003_(id));
    }

    public void abandonJob() {
        this.entity.m_6274_().m_21889_(Activity.f_37979_);
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, Chore.NONE);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.empty());
    }

    public void assignJob(Chore chore, Player player) {
        this.entity.m_6274_().m_21889_((Activity)ActivityMCA.CHORE.get());
        ((CTrackedEntity)this.entity).setTrackedValue(ACTIVE_CHORE, chore);
        ((CTrackedEntity)this.entity).setTrackedValue(CHORE_ASSIGNING_PLAYER, Optional.of(player.m_142081_()));
        this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
        this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get());
    }

    public void randomize() {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, Personality.getRandom());
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, ((Mob)this.entity).f_19853_.f_46441_.nextInt(31) + -15);
    }

    public void setPersonality(Personality p) {
        ((CTrackedEntity)this.entity).setTrackedValue(PERSONALITY, p);
    }

    public void updateMemories(Memories memories) {
        CompoundTag nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new CompoundTag() : nbt.m_6426_();
        nbt.m_128365_(memories.getPlayerUUID().toString(), (Tag)memories.toCNBT());
        ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
    }

    public Map<UUID, Memories> getMemories() {
        CompoundTag nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        HashMap<UUID, Memories> memories = new HashMap<UUID, Memories>();
        for (String uuid : nbt.m_128431_()) {
            memories.put(UUID.fromString(uuid), Memories.fromCNBT(this.entity, nbt.m_128469_(uuid)));
        }
        return memories;
    }

    public Memories getMemoriesForPlayer(Player player) {
        CompoundTag nbt = (CompoundTag)((CTrackedEntity)this.entity).getTrackedValue(MEMORIES);
        nbt = nbt == null ? new CompoundTag() : nbt;
        CompoundTag compoundTag = nbt.m_128469_(player.m_142081_().toString());
        Memories returnMemories = Memories.fromCNBT(this.entity, compoundTag);
        if (returnMemories == null) {
            returnMemories = new Memories(this, player.f_19853_.m_46468_(), player.m_142081_());
            nbt.m_128365_(player.m_142081_().toString(), (Tag)returnMemories.toCNBT());
            ((CTrackedEntity)this.entity).setTrackedValue(MEMORIES, nbt);
        }
        return returnMemories;
    }

    public Personality getPersonality() {
        return (Personality)((Object)((CTrackedEntity)this.entity).getTrackedValue(PERSONALITY));
    }

    public Mood getMood() {
        return this.getPersonality().getMoodGroup().getMood((Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD));
    }

    public boolean isPanicking() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(PANICKING);
    }

    public void modifyMoodValue(int mood) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOOD, MoodGroup.clampMood(this.getMoodValue() + mood));
    }

    public int getMoodValue() {
        return (Integer)((CTrackedEntity)this.entity).getTrackedValue(MOOD);
    }

    public MoveState getMoveState() {
        return (MoveState)((Object)((CTrackedEntity)this.entity).getTrackedValue(MOVE_STATE));
    }

    public void setMoveState(MoveState state, @Nullable Player leader) {
        ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, state);
        if (state == MoveState.MOVE) {
            this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
            this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get());
        }
        if (state == MoveState.STAY) {
            this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get());
            this.entity.m_6274_().m_21879_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get(), (Object)true);
        }
        if (state == MoveState.FOLLOW) {
            this.entity.m_6274_().m_21879_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get(), (Object)leader);
            this.entity.m_6274_().m_21936_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get());
            this.abandonJob();
        }
    }

    public void setArmorWear(boolean s) {
        ((CTrackedEntity)this.entity).setTrackedValue(WEAR_ARMOR, s);
    }

    public boolean getArmorWear() {
        return (Boolean)((CTrackedEntity)this.entity).getTrackedValue(WEAR_ARMOR);
    }

    public void updateMoveState() {
        if (this.getMoveState() == MoveState.FOLLOW && this.entity.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isEmpty()) {
            if (this.entity.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get()).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.STAY);
            } else if (this.entity.m_6274_().m_21952_((MemoryModuleType)MemoryModuleTypeMCA.PLAYER_FOLLOWING.get()).isPresent()) {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.FOLLOW);
            } else {
                ((CTrackedEntity)this.entity).setTrackedValue(MOVE_STATE, MoveState.MOVE);
            }
        }
    }

    public void rewardHearts(ServerPlayer player, int hearts) {
        Memories memory = ((VillagerLike)this.entity).getVillagerBrain().getMemoriesForPlayer((Player)player);
        if (hearts == 0) {
            return;
        }
        if (hearts > 0) {
            ((Mob)this.entity).f_19853_.m_7605_(this.entity, (byte)16);
        } else {
            ((Mob)this.entity).f_19853_.m_7605_(this.entity, (byte)15);
            if (((VillagerLike)this.entity).getVillagerBrain().getPersonality() == Personality.SENSITIVE) {
                hearts *= 2;
            }
        }
        memory.modInteractionFatigue(1);
        memory.modHearts(hearts);
        CriterionMCA.HEARTS_CRITERION.trigger(player, memory.getHearts(), hearts, "interaction");
        ((VillagerLike)this.entity).getVillagerBrain().modifyMoodValue(hearts);
    }
}

