/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import mca.entity.VillagerEntityMCA;
import mca.server.world.data.Building;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.level.Level;

public class EnterBuildingTask
extends Behavior<VillagerEntityMCA> {
    private final String building;
    private final float speed;

    public EnterBuildingTask(String building, float speed) {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED));
        this.building = building;
        this.speed = speed;
    }

    protected void run(ServerLevel serverWorld, VillagerEntityMCA villager, long l) {
        Optional<BlockPos> blockPos = this.getNextPosition(villager);
        blockPos.ifPresent(pos -> BehaviorUtils.m_22617_((LivingEntity)villager, (BlockPos)pos, (float)this.speed, (int)1));
    }

    protected Optional<Building> getNearestBuilding(VillagerEntityMCA villager) {
        return villager.getResidency().getHomeVillage().flatMap(buildings -> buildings.getBuildings().values().stream().filter(a -> a.getType().equals(this.getBuilding(villager))).min(Comparator.comparingInt(a -> a.getCenter().m_123333_((Vec3i)villager.m_142538_()))));
    }

    protected Optional<BlockPos> getRandomPositionIn(Building b, Level world) {
        Random r = world.m_5822_();
        BlockPos pos0 = b.getPos0();
        BlockPos pos1 = b.getPos1();
        BlockPos diff = pos1.m_141950_((Vec3i)pos0);
        int margin = 2;
        for (int attempt = 0; attempt < 16; ++attempt) {
            BlockPos p = pos0.m_141952_((Vec3i)new BlockPos(r.nextInt(Math.max(1, diff.m_123341_() - margin * 2)) + margin, r.nextInt(Math.max(1, diff.m_123342_() - margin * 2)) + margin, r.nextInt(Math.max(1, diff.m_123343_() - margin * 2)) + margin));
            if (world.m_45527_(p)) continue;
            return Optional.of(p);
        }
        return Optional.empty();
    }

    protected Optional<BlockPos> getNextPosition(VillagerEntityMCA villager) {
        Optional<Building> b = this.getNearestBuilding(villager);
        if (b.isPresent() && !b.get().containsPos((Vec3i)villager.m_142538_())) {
            return this.getRandomPositionIn(b.get(), villager.f_19853_);
        }
        return Optional.empty();
    }

    public String getBuilding(VillagerEntityMCA villager) {
        return this.building;
    }
}

