/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks;

import com.google.gson.JsonSyntaxException;
import mca.Config;
import mca.entity.ai.MemoryModuleTypeMCA;
import mca.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.Vec3;

public class WanderOrTeleportToTargetTask
extends MoveToTargetSink {
    public WanderOrTeleportToTargetTask() {
    }

    public WanderOrTeleportToTargetTask(int minRunTime, int maxRunTime) {
        super(minRunTime, maxRunTime);
    }

    protected boolean m_6114_(ServerLevel serverWorld, Mob mobEntity) {
        return super.m_6114_(serverWorld, mobEntity) && mobEntity.m_6274_().m_21876_((MemoryModuleType)MemoryModuleTypeMCA.STAYING.get(), MemoryStatus.VALUE_ABSENT);
    }

    protected void m_6725_(ServerLevel world, Mob entity, long l) {
        WalkTarget walkTarget;
        BlockPos targetPos;
        if (Config.getInstance().allowVillagerTeleporting && !(targetPos = (walkTarget = (WalkTarget)entity.m_6274_().m_21952_(MemoryModuleType.f_26370_).get()).m_26420_().m_6675_()).m_203195_((Position)entity.m_20182_(), Config.getInstance().villagerTeleportLimit)) {
            this.tryTeleport(world, entity, targetPos);
        }
        super.m_6725_(world, entity, l);
    }

    private void tryTeleport(ServerLevel world, Mob entity, BlockPos targetPos) {
        for (int i = 0; i < 10; ++i) {
            int j = this.getRandomInt(entity, -3, 3);
            int k = this.getRandomInt(entity, -1, 1);
            int l = this.getRandomInt(entity, -3, 3);
            boolean bl = this.tryTeleportTo(world, entity, targetPos, targetPos.m_123341_() + j, targetPos.m_123342_() + k, targetPos.m_123343_() + l);
            if (!bl) continue;
            return;
        }
    }

    private boolean tryTeleportTo(ServerLevel world, Mob entity, BlockPos targetPos, int x, int y, int z) {
        if (Math.abs((double)x - (double)targetPos.m_123341_()) < 2.0 && Math.abs((double)z - (double)targetPos.m_123343_()) < 2.0) {
            return false;
        }
        if (!this.canTeleportTo(world, entity, new BlockPos(x, y, z))) {
            return false;
        }
        entity.m_6021_((double)x + 0.5, (double)y, (double)z + 0.5);
        return true;
    }

    private boolean canTeleportTo(ServerLevel world, Mob entity, BlockPos pos) {
        BlockPathTypes pathNodeType = WalkNodeEvaluator.m_77604_((BlockGetter)world, (BlockPos.MutableBlockPos)pos.m_122032_());
        if (pathNodeType != BlockPathTypes.WALKABLE) {
            return false;
        }
        if (!this.isAreaSafe(world, pos.m_7495_())) {
            return false;
        }
        BlockPos blockPos = pos.m_141950_((Vec3i)entity.m_142538_());
        return world.m_45756_((Entity)entity, entity.m_142469_().m_82338_(blockPos));
    }

    private int getRandomInt(Mob entity, int min, int max) {
        return entity.m_21187_().nextInt(max - min + 1) + min;
    }

    private boolean isAreaSafe(ServerLevel world, Vec3 pos) {
        return this.isAreaSafe(world, new BlockPos(pos));
    }

    private boolean isAreaSafe(ServerLevel world, BlockPos pos) {
        BlockState aboveState = world.m_8055_(pos);
        ResourceLocation aboveId = Registry.f_122824_.m_7981_((Object)aboveState.m_60734_());
        for (String blockId : Config.getInstance().villagerPathfindingBlacklist) {
            if (blockId.equals(aboveId.toString())) {
                return false;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)identifier);
            if (tag != null && !RegistryHelper.isTagEmpty(tag)) {
                if (!aboveState.m_204336_(tag)) continue;
                return false;
            }
            throw new JsonSyntaxException("Unknown block tag in villagerPathfindingBlacklist '" + identifier + "'");
        }
        return true;
    }
}

