/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import mca.Config;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.TaskUtils;
import mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import mca.util.InventoryUtils;
import mca.util.RegistryHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class ChoppingTask
extends AbstractChoreTask {
    private int chopTicks;
    private int targetTreeTicks;
    private BlockPos targetTree;

    public ChoppingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.CHOP;
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager) && villager.m_21223_() == villager.m_21233_();
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.m_21120_(InteractionHand.MAIN_HAND);
        if (!stack.m_41619_()) {
            villager.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        villager.m_6674_(InteractionHand.MAIN_HAND);
    }

    @Override
    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof AxeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.chopping.noaxe");
            } else {
                villager.m_21008_(InteractionHand.MAIN_HAND, villager.m_141944_().m_8020_(i));
            }
        }
    }

    @Override
    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((Container)villager.m_141944_(), AxeItem.class) && !villager.m_21033_(EquipmentSlot.MAINHAND)) {
            this.abandonJobWithMessage("chore.chopping.noaxe");
        } else if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof AxeItem);
            ItemStack stack2 = villager.m_141944_().m_8020_(i);
            villager.m_21008_(InteractionHand.MAIN_HAND, stack2);
        }
        if (this.targetTree == null) {
            List<BlockPos> nearbyLogs = TaskUtils.getNearbyBlocks(villager.m_142538_(), (Level)world, blockState -> blockState.m_204336_(BlockTags.f_13106_), 15, 5);
            ArrayList<BlockPos> nearbyTrees = new ArrayList<BlockPos>();
            nearbyLogs.stream().filter(log -> this.isTreeStartLog(world, (BlockPos)log)).forEach(nearbyTrees::add);
            this.targetTree = TaskUtils.getNearestPoint(villager.m_142538_(), nearbyTrees);
            if (this.targetTree != null) {
                BlockState state;
                ItemStack stack3 = villager.m_21120_(InteractionHand.MAIN_HAND);
                BlockPos pos = this.targetTree;
                while ((state = world.m_8055_(pos)).m_204336_(BlockTags.f_13106_)) {
                    this.targetTreeTicks = (int)((float)this.targetTreeTicks + (float)this.getTicksFor(state, 60) / stack3.m_41691_(state));
                    pos = pos.m_142082_(0, 1, 0);
                }
            }
            return;
        }
        villager.moveTowards(this.targetTree);
        BlockState state = world.m_8055_(this.targetTree);
        if (state.m_204336_(BlockTags.f_13106_)) {
            villager.m_6674_(InteractionHand.MAIN_HAND);
            ++this.chopTicks;
            if (this.chopTicks >= this.targetTreeTicks) {
                this.chopTicks = 0;
                this.destroyTree(world, this.targetTree);
            }
        } else {
            this.targetTree = null;
            this.targetTreeTicks = 0;
        }
        super.keepRunning(world, villager, time);
    }

    private boolean isTreeStartLog(ServerLevel world, BlockPos origin) {
        if (!world.m_8055_(origin).m_204336_(BlockTags.f_13106_)) {
            return false;
        }
        if (!this.isValidTree(world, origin.m_7495_())) {
            return false;
        }
        BlockPos.MutableBlockPos pos_up = origin.m_122032_();
        for (int y = 0; y < Config.getInstance().maxTreeHeight; ++y) {
            BlockState up = world.m_8055_((BlockPos)pos_up.m_142448_(pos_up.m_123342_() + 1));
            if (up.m_204336_(BlockTags.f_13106_)) continue;
            return up.m_204336_(BlockTags.f_13035_);
        }
        return false;
    }

    private void destroyTree(ServerLevel world, BlockPos origin) {
        BlockState state;
        ItemStack stack = this.villager.m_21120_(InteractionHand.MAIN_HAND);
        BlockPos pos = origin;
        while ((state = world.m_8055_(pos)).m_204336_(BlockTags.f_13106_)) {
            world.m_46953_(pos, false, (Entity)this.villager);
            pos = pos.m_142082_(0, 1, 0);
            this.villager.m_141944_().m_19173_(new ItemStack((ItemLike)state.m_60734_(), 1));
            stack.m_41622_(1, (LivingEntity)this.villager, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        }
    }

    private boolean isValidTree(ServerLevel world, Vec3 pos) {
        return this.isValidTree(world, new BlockPos(pos));
    }

    private boolean isValidTree(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        ResourceLocation stateId = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        for (String blockId : Config.getInstance().validTreeSources) {
            if (blockId.equals(stateId.toString())) {
                return true;
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)identifier);
            if (tag != null && !RegistryHelper.isTagEmpty(tag)) {
                if (!state.m_204336_(tag)) continue;
                return true;
            }
            throw new JsonSyntaxException("Unknown block tag in validTreeSources '" + identifier + "'");
        }
        return false;
    }

    private int getTicksFor(BlockState state, int fallback) {
        Map<String, Integer> sources = Config.getInstance().maxTreeTicks;
        ResourceLocation stateId = Registry.f_122824_.m_7981_((Object)state.m_60734_());
        for (String blockId : sources.keySet()) {
            if (blockId.equals(stateId.toString())) {
                return sources.get(blockId);
            }
            if (blockId.charAt(0) != '#') continue;
            ResourceLocation identifier = new ResourceLocation(blockId.substring(1));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)identifier);
            if (tag != null && !RegistryHelper.isTagEmpty(tag)) {
                if (!state.m_204336_(tag)) continue;
                return sources.get(blockId);
            }
            throw new JsonSyntaxException("Unknown block tag in maxTreeTicks '" + identifier + "'");
        }
        return fallback;
    }
}

