/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import mca.TagsMCA;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.TaskUtils;
import mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import mca.item.NonPlayerItemUsageContext;
import mca.util.InventoryUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HarvestingTask
extends AbstractChoreTask {
    private static final int TICKS_PER_TURN = 15;
    private static final int ITEM_READY = 0;
    private static final int ITEM_FOUND = 1;
    private static final int ITEM_MISSING = 2;
    private final List<BlockPos> harvestable = new ArrayList<BlockPos>();
    private int lastCropScan = 0;
    private int lastActionTicks = 0;

    public HarvestingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HARVEST;
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager) && villager.m_21223_() == villager.m_21233_();
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.m_21120_(InteractionHand.MAIN_HAND);
        if (!stack.m_41619_()) {
            villager.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
    }

    @Override
    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof HoeItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.harvesting.nohoe");
            } else {
                ItemStack stack2 = villager.m_141944_().m_8020_(i);
                villager.m_21008_(InteractionHand.MAIN_HAND, stack2);
            }
        }
    }

    private BlockPos searchCrop(int rangeX, int rangeY, boolean harvestableOnly) {
        List<BlockPos> nearbyCrops = TaskUtils.getNearbyBlocks(this.villager.m_142538_(), this.villager.f_19853_, blockState -> blockState.m_204336_(BlockTags.f_13073_) || blockState.m_60734_() instanceof StemGrownBlock, rangeX, rangeY);
        this.harvestable.clear();
        if (harvestableOnly) {
            this.harvestable.addAll(nearbyCrops.stream().filter(pos -> {
                CropBlock crop;
                BlockState state = this.villager.f_19853_.m_8055_(pos);
                Block patt3791$temp = state.m_60734_();
                return patt3791$temp instanceof CropBlock && (crop = (CropBlock)patt3791$temp).m_52307_(state) || state.m_60734_() instanceof StemGrownBlock;
            }).toList());
        }
        return TaskUtils.getNearestPoint(this.villager.m_142538_(), this.harvestable.isEmpty() ? nearbyCrops : this.harvestable);
    }

    private BlockPos searchUnusedFarmLand(int rangeX, int rangeY) {
        return TaskUtils.getNearestPoint(this.villager.m_142538_(), TaskUtils.getNearbyBlocks(this.villager.m_142538_(), this.villager.f_19853_, blockState -> blockState.m_60713_(Blocks.f_50093_), rangeX, rangeY).stream().filter(pos -> {
            BlockState state = this.villager.f_19853_.m_8055_(pos);
            return state.m_60734_() instanceof FarmBlock && state.m_60710_((LevelReader)this.villager.f_19853_, pos) && this.villager.f_19853_.m_8055_(pos.m_7494_()).m_60795_();
        }).toList());
    }

    @Override
    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((Container)villager.m_141944_(), HoeItem.class) && !villager.m_21033_(EquipmentSlot.MAINHAND)) {
            this.abandonJobWithMessage("chore.harvesting.nohoe");
        } else if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof HoeItem);
            ItemStack stack2 = villager.m_141944_().m_8020_(i);
            villager.m_21008_(InteractionHand.MAIN_HAND, stack2);
        }
        BlockPos fertileFarmLand = this.searchUnusedFarmLand(16, 3);
        if (fertileFarmLand == null && villager.f_19797_ - this.lastCropScan > 1200) {
            this.lastCropScan = villager.f_19797_;
            fertileFarmLand = this.searchUnusedFarmLand(32, 16);
        }
        if (fertileFarmLand != null && villager.m_35516_()) {
            villager.moveTowards(fertileFarmLand);
            if (villager.m_20238_(Vec3.m_82539_((Vec3i)fertileFarmLand)) <= 6.0 && this.tickAction()) {
                this.plantSeeds(world, villager, fertileFarmLand.m_7494_());
            }
            return;
        }
        BlockPos crops = this.searchCrop(16, 3, true);
        if (crops == null && villager.f_19797_ - this.lastCropScan > 1200) {
            crops = this.searchCrop(32, 16, true);
        }
        if (crops == null) {
            return;
        }
        if (this.harvestable.isEmpty()) {
            crops = this.searchCrop(16, 3, false);
        }
        villager.moveTowards(crops);
        if (villager.m_20238_(Vec3.m_82539_((Vec3i)crops)) <= 4.5 && this.tickAction()) {
            BlockState state = world.m_8055_(crops);
            Block block = state.m_60734_();
            if (block instanceof CropBlock) {
                CropBlock crop = (CropBlock)block;
                if (crop.m_52307_(state)) {
                    this.harvestCrops(world, crops);
                    this.plantSeeds(world, villager, crops);
                } else {
                    this.bonemealCrop(world, villager, state, crops);
                }
            } else if (state.m_60734_() instanceof StemGrownBlock) {
                this.harvestCrops(world, crops);
            }
        }
    }

    private boolean tickAction() {
        if (this.lastActionTicks < 15) {
            ++this.lastActionTicks;
            return false;
        }
        this.lastActionTicks = 0;
        return true;
    }

    private int swapItem(Predicate<ItemStack> find) {
        ItemStack stack = this.villager.m_21205_();
        if (find.test(stack)) {
            return 0;
        }
        SimpleContainer inventory = this.villager.m_141944_();
        int slot = InventoryUtils.getFirstSlotContainingItem((Container)inventory, find);
        if (slot < 0) {
            return 2;
        }
        ItemStack found = inventory.m_8016_(slot);
        inventory.m_6836_(slot, stack);
        this.villager.m_21008_(InteractionHand.MAIN_HAND, found);
        return 1;
    }

    private void plantSeeds(ServerLevel world, VillagerEntityMCA villager, BlockPos target) {
        BlockHitResult hitResult = new BlockHitResult(Vec3.m_82539_((Vec3i)target), Direction.DOWN, target, true);
        InteractionResult result = InventoryUtils.stream((Container)villager.m_141944_()).filter(stack -> !stack.m_41619_() && stack.m_41720_() instanceof BlockItem && stack.m_204117_(TagsMCA.Items.VILLAGER_PLANTABLE)).map(stack -> stack.m_41661_((UseOnContext)new NonPlayerItemUsageContext((Level)world, InteractionHand.MAIN_HAND, (ItemStack)stack, hitResult))).filter(InteractionResult::m_19077_).findFirst().orElse(InteractionResult.FAIL);
        if (result.m_19077_()) {
            if (result.m_19080_()) {
                villager.m_6674_(InteractionHand.MAIN_HAND);
            }
        } else if (this.getAssigningPlayer().isPresent()) {
            villager.sendChatMessage(this.getAssigningPlayer().get(), "chore.harvesting.noseed", new Object[0]);
        }
    }

    private void bonemealCrop(ServerLevel world, VillagerEntityMCA villager, BlockState state, BlockPos pos) {
        if (this.swapItem(stack -> stack.m_150930_(Items.f_42499_)) == 0 && BoneMealItem.m_40627_((ItemStack)villager.m_21205_(), (Level)world, (BlockPos)pos)) {
            villager.m_6674_(InteractionHand.MAIN_HAND);
        }
    }

    private void harvestCrops(ServerLevel world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        LootContext.Builder lootcontext$builder = new LootContext.Builder(world).m_78972_(LootContextParams.f_81460_, (Object)this.villager.m_20182_()).m_78972_(LootContextParams.f_81463_, (Object)ItemStack.f_41583_).m_78972_(LootContextParams.f_81455_, (Object)this.villager).m_78972_(LootContextParams.f_81461_, (Object)state).m_78977_(this.villager.m_21187_()).m_78963_(0.0f);
        List drops = world.m_142572_().m_129898_().m_79217_(state.m_60734_().m_60589_()).m_79129_(lootcontext$builder.m_78975_(LootContextParamSets.f_81421_));
        for (ItemStack stack : drops) {
            this.villager.m_141944_().m_19173_(stack);
        }
        world.m_46953_(pos, false, (Entity)this.villager);
    }
}

