/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import java.util.Comparator;
import java.util.Map;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import mca.util.InventoryUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class HuntingTask
extends AbstractChoreTask {
    private int ticks = 0;
    private int nextAction = 0;
    private Animal target = null;

    public HuntingTask() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.VALUE_ABSENT, (Object)MemoryModuleType.f_26370_, (Object)MemoryStatus.VALUE_ABSENT));
    }

    protected boolean shouldRun(ServerLevel world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.HUNT;
    }

    protected boolean shouldKeepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        return this.shouldRun(world, villager) && villager.m_21223_() == villager.m_21233_();
    }

    protected void finishRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        ItemStack stack = villager.m_21120_(InteractionHand.MAIN_HAND);
        if (!stack.m_41619_()) {
            villager.m_21008_(InteractionHand.MAIN_HAND, ItemStack.f_41583_);
        }
        villager.m_6674_(InteractionHand.MAIN_HAND);
    }

    @Override
    protected void run(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.run(world, villager, time);
        if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof SwordItem);
            if (i == -1) {
                this.abandonJobWithMessage("chore.hunting.nosword");
            } else {
                ItemStack stack2 = villager.m_141944_().m_8020_(i);
                villager.m_21008_(InteractionHand.MAIN_HAND, stack2);
            }
        }
    }

    @Override
    protected void keepRunning(ServerLevel world, VillagerEntityMCA villager, long time) {
        super.keepRunning(world, villager, time);
        if (!InventoryUtils.contains((Container)villager.m_141944_(), SwordItem.class) && !villager.m_21033_(EquipmentSlot.MAINHAND)) {
            this.abandonJobWithMessage("chore.hunting.nosword");
        } else if (!villager.m_21033_(EquipmentSlot.MAINHAND)) {
            int i = InventoryUtils.getFirstSlotContainingItem((Container)villager.m_141944_(), stack -> stack.m_41720_() instanceof SwordItem);
            ItemStack stack2 = villager.m_141944_().m_8020_(i);
            villager.m_21008_(InteractionHand.MAIN_HAND, stack2);
        }
        if (this.target == null) {
            ++this.ticks;
            if (this.ticks >= this.nextAction) {
                this.ticks = 0;
                if ((double)villager.f_19853_.f_46441_.nextFloat() >= 0.0) {
                    villager.f_19853_.m_45976_(Animal.class, villager.m_142469_().m_82377_(15.0, 3.0, 15.0)).stream().filter(a -> !(a instanceof TamableAnimal)).min(Comparator.comparingDouble(arg_0 -> ((VillagerEntityMCA)villager).m_20280_(arg_0))).ifPresent(animal -> {
                        this.target = animal;
                        villager.moveTowards(this.target.m_142538_());
                    });
                }
                this.nextAction = 50;
            }
        } else {
            villager.moveTowards(this.target.m_142538_());
            if (this.target.m_21224_()) {
                villager.f_19853_.m_45976_(ItemEntity.class, villager.m_142469_().m_82377_(15.0, 3.0, 15.0)).forEach(item -> {
                    villager.m_141944_().m_19173_(item.m_32055_());
                    item.m_146870_();
                });
                this.target = null;
            } else if (villager.m_20280_((Entity)this.target) <= 12.25) {
                villager.moveTowards(this.target.m_142538_());
                villager.m_6674_(InteractionHand.MAIN_HAND);
                this.target.m_6469_(DamageSource.m_19370_((LivingEntity)villager), 6.0f);
                villager.m_21205_().m_41622_(1, (LivingEntity)villager, player -> player.m_21166_(EquipmentSlot.MAINHAND));
            }
        }
    }
}

