/*
 * Decompiled with CFR 0.152.
 */
package mca.entity.interaction.gifts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import mca.entity.VillagerEntityMCA;
import mca.entity.ai.Chore;
import mca.entity.ai.MoodGroup;
import mca.entity.ai.Traits;
import mca.entity.ai.relationship.AgeState;
import mca.entity.ai.relationship.Gender;
import mca.entity.ai.relationship.Personality;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class GiftPredicate {
    public static final Map<String, Factory<JsonElement>> CONDITION_TYPES = new HashMap<String, Factory<JsonElement>>();
    private final int satisfactionBoost;
    @Nullable
    private final Condition condition;
    List<String> conditionKeys;

    public static <T> void register(String name, BiFunction<JsonElement, String, T> jsonParser, Factory<T> predicate) {
        CONDITION_TYPES.put(name, json -> predicate.parse(jsonParser.apply((JsonElement)json, name)));
    }

    public static GiftPredicate fromJson(JsonObject json) {
        int satisfaction = 0;
        @Nullable Condition condition = null;
        LinkedList<String> conditionKeys = new LinkedList<String>();
        for (Map.Entry entry : json.entrySet()) {
            if ("satisfaction_boost".equals(entry.getKey())) {
                satisfaction = GsonHelper.m_13897_((JsonElement)((JsonElement)entry.getValue()), (String)((String)entry.getKey()));
                continue;
            }
            if (!CONDITION_TYPES.containsKey(entry.getKey())) continue;
            Condition parsed = CONDITION_TYPES.get(entry.getKey()).parse((JsonElement)entry.getValue());
            conditionKeys.add((String)entry.getKey());
            if (condition == null) {
                condition = parsed;
                continue;
            }
            condition = condition.and(parsed);
        }
        return new GiftPredicate(satisfaction, condition, conditionKeys);
    }

    public GiftPredicate(int satisfactionBoost, @Nullable Condition condition, List<String> conditionKeys) {
        this.satisfactionBoost = satisfactionBoost;
        this.condition = condition;
        this.conditionKeys = conditionKeys;
    }

    public boolean test(VillagerEntityMCA recipient, ItemStack stack, @Nullable ServerPlayer player) {
        return this.condition != null && this.condition.test(recipient, stack, player);
    }

    public int getSatisfactionFor(VillagerEntityMCA recipient, ItemStack stack, @Nullable ServerPlayer player) {
        return this.test(recipient, stack, player) ? this.satisfactionBoost : 0;
    }

    public List<String> getConditionKeys() {
        return this.conditionKeys;
    }

    static {
        GiftPredicate.register("profession", (json, name) -> new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name)), profession -> (villager, stack, player) -> Registry.f_122869_.m_7981_((Object)villager.getProfession()).equals(profession));
        GiftPredicate.register("age_group", (json, name) -> AgeState.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), group -> (villager, stack, player) -> villager.getAgeState() == group);
        GiftPredicate.register("gender", (json, name) -> Gender.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getGenetics().getGender() == gender);
        GiftPredicate.register("has_item", (json, name) -> Ingredient.m_43917_((JsonElement)json), item -> (villager, stack, player) -> {
            for (int i = 0; i < villager.m_141944_().m_6643_(); ++i) {
                if (!item.test(villager.m_141944_().m_8020_(i))) continue;
                return true;
            }
            return false;
        });
        GiftPredicate.register("min_health", GsonHelper::m_13888_, health -> (villager, stack, player) -> villager.m_21223_() > health.floatValue());
        GiftPredicate.register("is_married", GsonHelper::m_13877_, married -> (villager, stack, player) -> villager.getRelationships().isMarried() == married.booleanValue());
        GiftPredicate.register("has_home", GsonHelper::m_13877_, hasHome -> (villager, stack, player) -> villager.getResidency().getHome().isPresent() == hasHome.booleanValue());
        GiftPredicate.register("has_village", GsonHelper::m_13877_, hasVillage -> (villager, stack, player) -> villager.getResidency().getHomeVillage().isPresent() == hasVillage.booleanValue());
        GiftPredicate.register("min_infection_progress", GsonHelper::m_13888_, progress -> (villager, stack, player) -> villager.getInfectionProgress() > progress.floatValue());
        GiftPredicate.register("mood", (json, name) -> GsonHelper.m_13805_((JsonElement)json, (String)name).toLowerCase(Locale.ENGLISH), mood -> (villager, stack, player) -> villager.getVillagerBrain().getMood().getName().equals(mood));
        GiftPredicate.register("mood_group", (json, name) -> MoodGroup.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), moodGroup -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality().getMoodGroup() == moodGroup);
        GiftPredicate.register("personality", (json, name) -> Personality.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), personality -> (villager, stack, player) -> villager.getVillagerBrain().getPersonality() == personality);
        GiftPredicate.register("is_pregnant", GsonHelper::m_13877_, pregnant -> (villager, stack, player) -> villager.getRelationships().getPregnancy().isPregnant() == pregnant.booleanValue());
        GiftPredicate.register("min_pregnancy_progress", GsonHelper::m_13897_, progress -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getBabyAge() > progress);
        GiftPredicate.register("pregnancy_child_gender", (json, name) -> Gender.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), gender -> (villager, stack, player) -> villager.getRelationships().getPregnancy().getGender() == gender);
        GiftPredicate.register("current_chore", (json, name) -> Chore.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), chore -> (villager, stack, player) -> villager.getVillagerBrain().getCurrentJob() == chore);
        GiftPredicate.register("item", (json, name) -> {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name));
            Item item = (Item)Registry.f_122827_.m_6612_(id).orElseThrow(() -> new JsonSyntaxException("Unknown item '" + id + "'"));
            return Ingredient.m_43927_((ItemStack[])new ItemStack[]{new ItemStack((ItemLike)item)});
        }, ingredient -> (villager, stack, player) -> ingredient.test(stack));
        GiftPredicate.register("tag", (json, name) -> {
            ResourceLocation id = new ResourceLocation(GsonHelper.m_13805_((JsonElement)json, (String)name));
            TagKey tag = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)id);
            if (tag == null) {
                throw new JsonSyntaxException("Unknown item tag '" + id + "'");
            }
            return Ingredient.m_204132_((TagKey)tag);
        }, ingredient -> (villager, stack, player) -> ingredient.test(stack));
        GiftPredicate.register("trait", (json, name) -> Traits.Trait.valueOf(GsonHelper.m_13805_((JsonElement)json, (String)name).toUpperCase(Locale.ENGLISH)), trait -> (villager, stack, player) -> villager.getTraits().hasTrait((Traits.Trait)((Object)trait)));
        GiftPredicate.register("heartsMin", GsonHelper::m_13897_, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
            return h >= hearts;
        });
        GiftPredicate.register("heartsMax", GsonHelper::m_13897_, hearts -> (villager, stack, player) -> {
            assert (player != null);
            int h = villager.getVillagerBrain().getMemoriesForPlayer((Player)player).getHearts();
            return h <= hearts;
        });
    }

    public static interface Factory<T> {
        public Condition parse(T var1);
    }

    public static interface Condition {
        public boolean test(VillagerEntityMCA var1, ItemStack var2, @Nullable ServerPlayer var3);

        default public Condition and(Condition b) {
            Condition a = this;
            return (villager, stack, player) -> a.test(villager, stack, player) && b.test(villager, stack, player);
        }
    }
}

