/*
 * Decompiled with CFR 0.152.
 */
package mca.resources;

import com.google.gson.JsonElement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import mca.cobalt.network.NetworkHandler;
import mca.entity.VillagerEntityMCA;
import mca.network.s2c.AnalysisResults;
import mca.resources.Resources;
import mca.resources.data.SerializablePair;
import mca.resources.data.analysis.ChanceAnalysis;
import mca.resources.data.analysis.IntAnalysis;
import mca.resources.data.dialogue.Answer;
import mca.resources.data.dialogue.Question;
import mca.resources.data.dialogue.Result;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class Dialogues
extends SimpleJsonResourceReloadListener {
    protected static final ResourceLocation ID = new ResourceLocation("mca", "dialogues");
    private final Random random = new Random();
    private static Dialogues INSTANCE;
    private final Map<String, Question> questions = new HashMap<String, Question>();
    private final Map<String, List<Question>> questionGroups = new HashMap<String, List<Question>>();

    public static Dialogues getInstance() {
        return INSTANCE;
    }

    public Dialogues() {
        super(Resources.GSON, "dialogues");
        INSTANCE = this;
    }

    protected void apply(Map<ResourceLocation, JsonElement> data, ResourceManager manager, ProfilerFiller profiler) {
        this.questions.clear();
        data.forEach(this::loadDialogue);
    }

    private void loadDialogue(ResourceLocation identifier, JsonElement element) {
        String id = identifier.m_135815_().substring(identifier.m_135815_().lastIndexOf(47) + 1);
        Question q = Question.fromJson(id, element.getAsJsonObject());
        this.questions.put(id, q);
        this.questionGroups.computeIfAbsent(q.getGroup(), x -> new LinkedList());
        this.questionGroups.get(q.getGroup()).add(q);
    }

    public Question getQuestion(String i) {
        return this.questions.get(i);
    }

    public Question getRandomQuestion(String i) {
        if (this.questions.containsKey(i)) {
            return this.questions.get(i);
        }
        List<Question> questions = this.questionGroups.get(i);
        if (questions == null) {
            return null;
        }
        return questions.get(this.random.nextInt(questions.size()));
    }

    public void selectAnswer(VillagerEntityMCA villager, ServerPlayer player, String questionId, String answerId) {
        Question question = this.getQuestion(questionId);
        Answer answer = question.getAnswer(answerId);
        int total = 0;
        LinkedList<IntAnalysis> analysis = new LinkedList<IntAnalysis>();
        for (Result result : answer.getResults()) {
            IntAnalysis a = result.getChances(villager, player);
            analysis.add(a);
            total += a.getTotal().intValue();
        }
        int chosen = -1;
        total = total == 0 ? 0 : villager.m_21187_().nextInt(total);
        for (IntAnalysis a : analysis) {
            ++chosen;
            if ((total -= a.getTotal().intValue()) > 0) continue;
            break;
        }
        ChanceAnalysis chanceAnalysis = new ChanceAnalysis();
        for (int i = 0; i < analysis.size(); ++i) {
            boolean positive = answer.getResults().get(i).isPositive();
            for (SerializablePair value : ((IntAnalysis)analysis.get(i)).getSummands()) {
                chanceAnalysis.add(value.getLeft(), (Integer)value.getRight() * (positive ? 1 : -1));
            }
        }
        NetworkHandler.sendToPlayer(new AnalysisResults(chanceAnalysis), player);
        answer.getResults().get(chosen).getActions().trigger(villager, player);
    }
}

