/*
 * Decompiled with CFR 0.152.
 */
package mca.server;

import java.util.LinkedList;
import java.util.List;
import mca.Config;
import mca.ducks.IVillagerEntity;
import mca.entity.VillagerFactory;
import mca.entity.ZombieVillagerFactory;
import mca.entity.ai.relationship.Gender;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;

public class SpawnQueue {
    private static final SpawnQueue INSTANCE = new SpawnQueue();
    private final List<Villager> villagerSpawnQueue = new LinkedList<Villager>();
    private final List<ZombieVillager> zombieVillagerSpawnQueue = new LinkedList<ZombieVillager>();

    public static SpawnQueue getInstance() {
        return INSTANCE;
    }

    public void tick() {
        Villager e;
        if (!this.villagerSpawnQueue.isEmpty()) {
            e = this.villagerSpawnQueue.remove(0);
            if (e.f_19853_.m_46749_(e.m_142538_())) {
                e.m_146870_();
                VillagerFactory.newVillager(e.f_19853_).withName(e.m_8077_() ? e.m_7755_().getString() : null).withGender(Gender.getRandom()).withAge(e.m_146764_()).withPosition((Entity)e).withType(e.m_7141_().m_35560_()).withProfession(e.m_7141_().m_35571_(), e.m_7141_().m_35576_(), e.m_6616_()).spawn(((IVillagerEntity)e).getSpawnReason());
            } else {
                this.villagerSpawnQueue.add(e);
            }
        }
        if (!this.zombieVillagerSpawnQueue.isEmpty()) {
            e = this.zombieVillagerSpawnQueue.remove(0);
            if (e.f_19853_.m_46749_(e.m_142538_())) {
                e.m_146870_();
                ZombieVillagerFactory.newVillager(e.f_19853_).withName(e.m_8077_() ? e.m_7755_().getString() : null).withGender(Gender.getRandom()).withPosition((Entity)e).withType(e.m_7141_().m_35560_()).withProfession(e.m_7141_().m_35571_(), e.m_7141_().m_35576_()).spawn(((IVillagerEntity)e).getSpawnReason());
            } else {
                this.zombieVillagerSpawnQueue.add((ZombieVillager)e);
            }
        }
    }

    public boolean addVillager(Entity entity) {
        if (entity instanceof IVillagerEntity && !this.handlesSpawnReason(((IVillagerEntity)entity).getSpawnReason())) {
            return false;
        }
        if (Config.getInstance().overwriteOriginalVillagers && entity.getClass().equals(Villager.class) && !this.villagerSpawnQueue.contains(entity)) {
            return this.villagerSpawnQueue.add((Villager)entity);
        }
        if (Config.getInstance().overwriteOriginalZombieVillagers && entity.getClass().equals(ZombieVillager.class) && !this.zombieVillagerSpawnQueue.contains(entity)) {
            return this.zombieVillagerSpawnQueue.add((ZombieVillager)entity);
        }
        return false;
    }

    private boolean handlesSpawnReason(MobSpawnType reason) {
        return reason == MobSpawnType.NATURAL || reason == MobSpawnType.STRUCTURE;
    }
}

