/*
 * Decompiled with CFR 0.152.
 */
package mca.util;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public interface NbtHelper {
    public static <T extends Tag> T computeIfAbsent(CompoundTag nbt, String key, int type, Supplier<T> factory) {
        if (!nbt.m_128425_(key, type)) {
            nbt.m_128365_(key, (Tag)factory.get());
        }
        return (T)nbt.m_128423_(key);
    }

    public static CompoundTag copyTo(CompoundTag from, CompoundTag to) {
        from.m_128431_().forEach(key -> to.m_128365_(key, from.m_128423_(key)));
        return to;
    }

    public static <V> List<V> toList(Tag nbt, Function<Tag, V> valueMapper) {
        return NbtHelper.toStream(nbt, valueMapper).collect(Collectors.toList());
    }

    public static <V> Stream<V> toStream(Tag nbt, Function<Tag, V> valueMapper) {
        return ((ListTag)nbt).stream().map(valueMapper);
    }

    public static <K, V> Map<K, V> toMap(CompoundTag nbt, Function<String, K> keyMapper, Function<Tag, V> valueMapper) {
        return NbtHelper.toMap(nbt, keyMapper, (K k, Tag e) -> valueMapper.apply((Tag)e));
    }

    public static <K, V> Map<K, V> toMap(CompoundTag nbt, Function<String, K> keyMapper, BiFunction<K, Tag, V> valueMapper) {
        return nbt.m_128431_().stream().map(e -> {
            Object k = keyMapper.apply((String)e);
            if (k == null) {
                return null;
            }
            Object v = valueMapper.apply(k, nbt.m_128423_(e));
            if (v == null) {
                return null;
            }
            return k == null ? null : new Pair(k, v);
        }).filter(Objects::nonNull).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    public static <V> ListTag fromList(Iterable<V> list, Function<V, Tag> valueMapper) {
        ListTag output = new ListTag();
        list.forEach(item -> output.add((Object)((Tag)valueMapper.apply(item))));
        return output;
    }

    public static <K, V> CompoundTag fromMap(CompoundTag output, Map<K, V> map, Function<K, String> keyMapper, Function<V, Tag> valueMapper) {
        map.forEach((key, value) -> output.m_128365_((String)keyMapper.apply(key), (Tag)valueMapper.apply(value)));
        return output;
    }
}

