/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.chiseling.modes.plane;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import mod.chiselsandbits.api.axissize.CollisionType;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.change.IChangeTrackerManager;
import mod.chiselsandbits.api.chiseling.IChiselingContext;
import mod.chiselsandbits.api.chiseling.mode.IChiselMode;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.item.click.ClickProcessingState;
import mod.chiselsandbits.api.item.withmode.group.IToolModeGroup;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.api.multistate.accessor.IAreaAccessor;
import mod.chiselsandbits.api.multistate.accessor.IStateEntryInfo;
import mod.chiselsandbits.api.multistate.mutator.batched.IBatchMutation;
import mod.chiselsandbits.api.util.LocalStrings;
import mod.chiselsandbits.api.util.RayTracingUtils;
import mod.chiselsandbits.platforms.core.registries.AbstractCustomRegistryEntry;
import mod.chiselsandbits.registrars.ModChiselModeGroups;
import mod.chiselsandbits.utils.BitInventoryUtils;
import mod.chiselsandbits.utils.ItemStackUtils;
import mod.chiselsandbits.voxelshape.VoxelShapeManager;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class PlaneChiselMode
extends AbstractCustomRegistryEntry
implements IChiselMode {
    private final int depth;
    private final MutableComponent displayName;
    private final MutableComponent multiLineDisplayName;
    private final ResourceLocation iconName;

    PlaneChiselMode(int depth, MutableComponent displayName, MutableComponent multiLineDisplayName, ResourceLocation iconName) {
        this.depth = depth;
        this.displayName = displayName;
        this.multiLineDisplayName = multiLineDisplayName;
        this.iconName = iconName;
    }

    @Override
    public ClickProcessingState onLeftClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122424_().m_122436_()), Direction::m_122424_);
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                context.setComplete();
                HashMap resultingBitCount = Maps.newHashMap();
                Predicate<IStateEntryInfo> filter = context.getStateFilter().map(builder -> (Predicate)builder.apply(mutator)).orElse(state -> true);
                int totalModifiedStates = mutator.inWorldMutableStream().filter(filter).mapToInt(state -> {
                    BlockInformation currentState = state.getBlockInformation();
                    return context.tryDamageItemAndDoOrSetBrokenError(() -> {
                        resultingBitCount.putIfAbsent(currentState, 0);
                        resultingBitCount.computeIfPresent(currentState, (s, currentCount) -> currentCount + 1);
                        state.clear();
                    });
                }).sum();
                if (totalModifiedStates == 0) {
                    context.setError(LocalStrings.ChiselAttemptFailedNoValidStateFound.getText());
                }
                resultingBitCount.forEach((blockState, count) -> BitInventoryUtils.insertIntoOrSpawn(playerEntity, blockState, count));
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedLeftClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public ClickProcessingState onRightClickBy(Player playerEntity, IChiselingContext context) {
        Optional<ClickProcessingState> rayTraceHandle = this.processRayTraceIntoContext(playerEntity, context, face -> Vec3.m_82528_((Vec3i)face.m_122436_()), Function.identity());
        if (context.isSimulation()) {
            return ClickProcessingState.DEFAULT;
        }
        return rayTraceHandle.orElseGet(() -> context.getMutator().map(mutator -> {
            BlockPos heightPos;
            BlockInformation heldBlockState = ItemStackUtils.getHeldBitBlockInformationFromPlayer(playerEntity);
            if (heldBlockState.isAir()) {
                return ClickProcessingState.DEFAULT;
            }
            int missingBitCount = (int)mutator.stream().filter(state -> state.getBlockInformation().isAir()).count();
            IBitInventory playerBitInventory = IBitInventoryManager.getInstance().create(playerEntity);
            context.setComplete();
            if (playerBitInventory.canExtract(heldBlockState, missingBitCount) || playerEntity.m_7500_()) {
                if (!playerEntity.m_7500_()) {
                    playerBitInventory.extract(heldBlockState, missingBitCount);
                }
                try (IBatchMutation ignored = mutator.batch(IChangeTrackerManager.getInstance().getChangeTracker(playerEntity));){
                    mutator.inWorldMutableStream().filter(state -> state.getBlockInformation().isAir()).forEach(state -> state.overrideState(heldBlockState));
                }
            } else {
                context.setError(LocalStrings.ChiselAttemptFailedNotEnoughBits.getText(heldBlockState.getBlockState().m_60734_().m_49954_()));
            }
            if (missingBitCount == 0 && (heightPos = new BlockPos(mutator.getInWorldEndPoint())).m_123342_() >= context.getWorld().m_151558_()) {
                MutableComponent component = new TranslatableComponent("build.tooHigh", new Object[]{context.getWorld().m_151558_() - 1}).m_130940_(ChatFormatting.RED);
                playerEntity.m_6352_((Component)component, Util.f_137441_);
            }
            return ClickProcessingState.ALLOW;
        }).orElse(ClickProcessingState.DEFAULT));
    }

    @Override
    public void onStoppedRightClicking(Player playerEntity, IChiselingContext context) {
    }

    @Override
    public Optional<IAreaAccessor> getCurrentAccessor(IChiselingContext context) {
        return context.getMutator().map(mutator -> mutator);
    }

    private Optional<ClickProcessingState> processRayTraceIntoContext(Player playerEntity, IChiselingContext context, Function<Direction, Vec3> placementFacingAdapter, Function<Direction, Direction> iterationAdaptor) {
        HitResult rayTraceResult = RayTracingUtils.rayTracePlayer(playerEntity);
        if (rayTraceResult.m_6662_() != HitResult.Type.BLOCK || !(rayTraceResult instanceof BlockHitResult)) {
            context.setError(LocalStrings.ChiselAttemptFailedNoBlock.getText());
            return Optional.of(ClickProcessingState.DEFAULT);
        }
        BlockHitResult blockRayTraceResult = (BlockHitResult)rayTraceResult;
        Vec3 hitVector = blockRayTraceResult.m_82450_().m_82549_(placementFacingAdapter.apply(blockRayTraceResult.m_82434_()).m_82542_((double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit(), (double)StateEntrySize.current().getSizePerHalfBit()));
        Vec3 hitBlockPosVector = Vec3.m_82528_((Vec3i)new BlockPos(hitVector));
        Vec3 inBlockHitVector = hitVector.m_82546_(hitBlockPosVector);
        Vec3 inBlockBitVector = inBlockHitVector.m_82542_((double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide(), (double)StateEntrySize.current().getBitsPerBlockSide());
        Direction iterationDirection = iterationAdaptor.apply(blockRayTraceResult.m_82434_());
        switch (iterationDirection) {
            case DOWN: {
                this.includeDownAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case UP: {
                this.includeUpAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case NORTH: {
                this.includeNorthAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case SOUTH: {
                this.includeSouthAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case WEST: {
                this.includeWestAxis(context, hitBlockPosVector, inBlockBitVector);
                break;
            }
            case EAST: {
                this.includeEastAxis(context, hitBlockPosVector, inBlockBitVector);
            }
        }
        return Optional.empty();
    }

    private void includeDownAxis(IChiselingContext context, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, inBlockBitVector.m_7098_() - (double)this.depth, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.UP.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, inBlockBitVector.m_7098_() - (double)this.depth, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.UP.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, inBlockBitVector.m_7098_() - 0.5, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.UP.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, inBlockBitVector.m_7098_() - 0.5, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.UP.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeUpAxis(IChiselingContext context, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, inBlockBitVector.m_7098_() + (double)this.depth, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, inBlockBitVector.m_7098_() + (double)this.depth, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, inBlockBitVector.m_7098_() + 0.5, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, inBlockBitVector.m_7098_() + 0.5, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.DOWN.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeNorthAxis(IChiselingContext context, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, 0.0, inBlockBitVector.m_7094_() - (double)this.depth).m_82549_(Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, 15.5, inBlockBitVector.m_7094_() - (double)this.depth).m_82549_(Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, 0.0, inBlockBitVector.m_7094_() - 0.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, 15.5, inBlockBitVector.m_7094_() - 0.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.SOUTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeSouthAxis(IChiselingContext context, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, 0.0, inBlockBitVector.m_7094_() + (double)this.depth).m_82549_(Vec3.m_82528_((Vec3i)Direction.NORTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, 15.5, inBlockBitVector.m_7094_() + (double)this.depth).m_82549_(Vec3.m_82528_((Vec3i)Direction.NORTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(0.0, 0.0, inBlockBitVector.m_7094_() + 0.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.NORTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(15.5, 15.5, inBlockBitVector.m_7094_() + 0.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.NORTH.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeWestAxis(IChiselingContext context, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() - (double)this.depth, 0.0, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.EAST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() - (double)this.depth, 15.5, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.EAST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() - 0.5, 0.0, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.EAST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() - 0.5, 15.5, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.EAST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private void includeEastAxis(IChiselingContext context, Vec3 hitBlockPosVector, Vec3 inBlockBitVector) {
        BlockPos position = new BlockPos(hitBlockPosVector);
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() + (double)this.depth, 0.0, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.WEST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() + (double)this.depth, 15.5, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.WEST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() + 0.5, 0.0, 0.0).m_82549_(Vec3.m_82528_((Vec3i)Direction.WEST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
        context.include(position, this.clampVectorToBlock(new Vec3(inBlockBitVector.m_7096_() + 0.5, 15.5, 15.5).m_82549_(Vec3.m_82528_((Vec3i)Direction.WEST.m_122436_())).m_82542_((double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit(), (double)StateEntrySize.current().getSizePerBit())));
    }

    private Vec3 clampVectorToBlock(Vec3 v) {
        return new Vec3(v.m_7096_() < 0.0 ? 0.0 : (v.m_7096_() >= 1.0 ? (double)0.999f : v.m_7096_()), v.m_7098_() < 0.0 ? 0.0 : (v.m_7098_() >= 1.0 ? (double)0.999f : v.m_7098_()), v.m_7094_() < 0.0 ? 0.0 : (v.m_7094_() >= 1.0 ? (double)0.999f : v.m_7094_()));
    }

    @Override
    public VoxelShape getShape(IChiselingContext context) {
        if (context.getMutator().isEmpty()) {
            return Shapes.m_83040_();
        }
        return VoxelShapeManager.getInstance().get((IAreaAccessor)context.getMutator().get(), CollisionType.ALL);
    }

    @Override
    @NotNull
    public ResourceLocation getIcon() {
        return this.iconName;
    }

    @Override
    public Component getDisplayName() {
        return this.displayName;
    }

    @Override
    public Component getMultiLineDisplayName() {
        return this.multiLineDisplayName;
    }

    @Override
    @NotNull
    public Optional<IToolModeGroup> getGroup() {
        return Optional.of(ModChiselModeGroups.PLANE);
    }
}

