/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.config;

import java.util.function.Supplier;
import mod.chiselsandbits.api.config.IServerConfiguration;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.platforms.core.config.ConfigurationType;
import mod.chiselsandbits.platforms.core.config.IConfigurationBuilder;
import mod.chiselsandbits.platforms.core.config.IConfigurationManager;

public class ServerConfiguration
implements IServerConfiguration {
    private final Supplier<Boolean> blockListRandomTickingBlocks;
    private final Supplier<Boolean> compatibilityMode;
    private final Supplier<Integer> bagStackSize;
    private final Supplier<StateEntrySize> bitSize;
    private final Supplier<Integer> changeTrackerSize;
    private final Supplier<Boolean> deleteExcessBits;
    private final Supplier<Double> lightFactorMultiplier;

    public ServerConfiguration() {
        IConfigurationBuilder builder = IConfigurationManager.getInstance().createBuilder(ConfigurationType.SYNCED, "chiselsandbits-server");
        this.blockListRandomTickingBlocks = builder.defineBoolean("balancing.blacklist-random-ticking-blocks", false);
        this.compatibilityMode = builder.defineBoolean("balancing.enable-compatibility-mode", false);
        this.bagStackSize = builder.defineInteger("balancing.bit-bag-stack-size", 512, 64, Integer.MAX_VALUE);
        this.bitSize = builder.defineEnum("style.bit-size", StateEntrySize.ONE_SIXTEENTH);
        this.changeTrackerSize = builder.defineInteger("balancing.change-tracker-size", 20, 10, 40);
        this.deleteExcessBits = builder.defineBoolean("balancing.delete-excess-bits", true);
        this.lightFactorMultiplier = builder.defineDouble("balancing.light-factor-multiplier", 1.0, 0.0, 4096.0);
        builder.setup();
    }

    @Override
    public Supplier<Boolean> getBlackListRandomTickingBlocks() {
        return this.blockListRandomTickingBlocks;
    }

    @Override
    public Supplier<Boolean> getCompatabilityMode() {
        return this.compatibilityMode;
    }

    @Override
    public Supplier<Integer> getBagStackSize() {
        return this.bagStackSize;
    }

    @Override
    public Supplier<StateEntrySize> getBitSize() {
        return this.bitSize;
    }

    @Override
    public Supplier<Integer> getChangeTrackerSize() {
        return this.changeTrackerSize;
    }

    @Override
    public Supplier<Boolean> getDeleteExcessBits() {
        return this.deleteExcessBits;
    }

    @Override
    public Supplier<Double> getLightFactorMultiplier() {
        return this.lightFactorMultiplier;
    }
}

