/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.registrars;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import mod.chiselsandbits.block.BitStorageBlock;
import mod.chiselsandbits.block.ChiseledBlock;
import mod.chiselsandbits.block.ChiseledPrinterBlock;
import mod.chiselsandbits.block.ModificationTableBlock;
import mod.chiselsandbits.block.PatternScannerBlock;
import mod.chiselsandbits.materials.MaterialManager;
import mod.chiselsandbits.platforms.core.registries.deferred.IRegistrar;
import mod.chiselsandbits.platforms.core.registries.deferred.IRegistryObject;
import mod.chiselsandbits.utils.ReflectionHelperBlock;
import net.minecraft.core.Registry;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ModBlocks {
    public static final Map<Material, IRegistryObject<ChiseledBlock>> MATERIAL_TO_BLOCK_CONVERSIONS = Maps.newHashMap();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final IRegistrar<Block> BLOCK_REGISTRAR = IRegistrar.create(Registry.f_122901_, "chiselsandbits");
    public static final IRegistryObject<BitStorageBlock> BIT_STORAGE = BLOCK_REGISTRAR.register("bit_storage", () -> new BitStorageBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 6.0f).m_60999_().m_60988_().m_60955_().m_60922_((p_test_1_, p_test_2_, p_test_3_, p_test_4_) -> false).m_60924_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60960_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60971_((p_test_1_, p_test_2_, p_test_3_) -> false)));
    public static final IRegistryObject<ModificationTableBlock> MODIFICATION_TABLE = BLOCK_REGISTRAR.register("modification_table", () -> new ModificationTableBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 6.0f).m_60999_().m_60988_().m_60955_().m_60922_((p_test_1_, p_test_2_, p_test_3_, p_test_4_) -> false).m_60924_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60960_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60971_((p_test_1_, p_test_2_, p_test_3_) -> false)));
    public static final IRegistryObject<ChiseledPrinterBlock> CHISELED_PRINTER = BLOCK_REGISTRAR.register("chiseled_printer", () -> new ChiseledPrinterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(1.5f, 6.0f).m_60999_().m_60988_().m_60955_().m_60922_((p_test_1_, p_test_2_, p_test_3_, p_test_4_) -> false).m_60924_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60960_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60971_((p_test_1_, p_test_2_, p_test_3_) -> false)));
    public static final IRegistryObject<PatternScannerBlock> PATTERN_SCANNER = BLOCK_REGISTRAR.register("pattern_scanner", () -> new PatternScannerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(1.5f, 6.0f).m_60999_().m_60988_().m_60955_().m_60922_((p_test_1_, p_test_2_, p_test_3_, p_test_4_) -> false).m_60924_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60960_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60971_((p_test_1_, p_test_2_, p_test_3_) -> false)));
    public static IRegistryObject<ReflectionHelperBlock> REFLECTION_HELPER_BLOCK = BLOCK_REGISTRAR.register("reflection_helper_block", ReflectionHelperBlock::new);

    private ModBlocks() {
        throw new IllegalStateException("Tried to initialize: ModBlocks but this is a Utility class.");
    }

    public static void onModConstruction(Function<BlockBehaviour.Properties, ChiseledBlock> chiseledBlockFactory) {
        MaterialManager.getInstance().getKnownMaterials().forEach((name, material) -> MATERIAL_TO_BLOCK_CONVERSIONS.put((Material)material, BLOCK_REGISTRAR.register("chiseled" + name, () -> (ChiseledBlock)chiseledBlockFactory.apply(BlockBehaviour.Properties.m_60939_((Material)material).m_60913_(1.5f, 6.0f).m_60924_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60922_((p_test_1_, p_test_2_, p_test_3_, p_test_4_) -> false).m_60960_((p_test_1_, p_test_2_, p_test_3_) -> false).m_60955_()))));
        LOGGER.info("Loaded block configuration.");
    }
}

