/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

public class BitUtils {
    private BitUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: BitUtils. This is a utility class");
    }

    public static int getBitMask(int bitWidth) {
        if (bitWidth == 32) {
            return -1;
        }
        return (1 << bitWidth) - 1;
    }

    public static int getByteCount(int totalBitCount) {
        return (int)Math.ceil((float)totalBitCount / 8.0f);
    }

    public static int getMaskWidth(int bitMask) {
        if (bitMask == -1) {
            return 32;
        }
        int maxBit = bitMask + 1;
        return 32 - Integer.numberOfLeadingZeros(maxBit) - 1;
    }
}

