/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.utils;

import java.util.Random;
import mod.chiselsandbits.api.item.INoHitEffectsItem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.TerrainParticle;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class EffectUtils {
    private static final Random RANDOM = new Random();

    private EffectUtils() {
        throw new IllegalStateException("Can not instantiate an instance of: EffectUtils. This is a utility class");
    }

    public static void addBlockDestroyEffects(LevelReader levelReader, BlockPos pos, BlockState primaryState, ParticleEngine manager, Level renderingWorld) {
        if (!primaryState.m_60795_()) {
            VoxelShape voxelshape = levelReader.m_8055_(pos).m_60808_((BlockGetter)levelReader, pos);
            voxelshape.m_83286_((p_228348_3_, p_228348_5_, p_228348_7_, p_228348_9_, p_228348_11_, p_228348_13_) -> {
                double d1 = Math.min(1.0, p_228348_9_ - p_228348_3_);
                double d2 = Math.min(1.0, p_228348_11_ - p_228348_5_);
                double d3 = Math.min(1.0, p_228348_13_ - p_228348_7_);
                int i = Math.max(2, Mth.m_14165_((double)(d1 / 0.25)));
                int j = Math.max(2, Mth.m_14165_((double)(d2 / 0.25)));
                int k = Math.max(2, Mth.m_14165_((double)(d3 / 0.25)));
                for (int l = 0; l < i; ++l) {
                    for (int i1 = 0; i1 < j; ++i1) {
                        for (int j1 = 0; j1 < k; ++j1) {
                            double d4 = ((double)l + 0.5) / (double)i;
                            double d5 = ((double)i1 + 0.5) / (double)j;
                            double d6 = ((double)j1 + 0.5) / (double)k;
                            double d7 = d4 * d1 + p_228348_3_;
                            double d8 = d5 * d2 + p_228348_5_;
                            double d9 = d6 * d3 + p_228348_7_;
                            manager.m_107344_((Particle)new TerrainParticle((ClientLevel)renderingWorld, (double)pos.m_123341_() + d7, (double)pos.m_123342_() + d8, (double)pos.m_123343_() + d9, d4 - 0.5, d5 - 0.5, d6 - 0.5, primaryState, pos));
                        }
                    }
                }
            });
        }
    }

    public static boolean addHitEffects(Level world, BlockHitResult blockRayTraceResult, BlockState primaryState, ParticleEngine manager) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return false;
        }
        ItemStack hitWith = Minecraft.m_91087_().f_91074_.m_21205_();
        if (!hitWith.m_41619_() && hitWith.m_41720_() instanceof INoHitEffectsItem) {
            return true;
        }
        BlockPos pos = blockRayTraceResult.m_82425_();
        double boxOffset = 0.1;
        AABB bb = world.m_8055_(pos).m_60808_((BlockGetter)world, pos).m_83215_();
        double x = (double)pos.m_123341_() + RANDOM.nextDouble() * (bb.f_82291_ - bb.f_82288_ - 0.2) + 0.1 + bb.f_82288_;
        double y = (double)pos.m_123342_() + RANDOM.nextDouble() * (bb.f_82292_ - bb.f_82289_ - 0.2) + 0.1 + bb.f_82289_;
        double z = (double)pos.m_123343_() + RANDOM.nextDouble() * (bb.f_82293_ - bb.f_82290_ - 0.2) + 0.1 + bb.f_82290_;
        switch (blockRayTraceResult.m_82434_()) {
            case DOWN: {
                y = (double)pos.m_123342_() + bb.f_82289_ - 0.1;
                break;
            }
            case UP: {
                y = (double)pos.m_123342_() + bb.f_82292_ + 0.1;
                break;
            }
            case NORTH: {
                z = (double)pos.m_123343_() + bb.f_82290_ - 0.1;
                break;
            }
            case SOUTH: {
                z = (double)pos.m_123343_() + bb.f_82293_ + 0.1;
                break;
            }
            case WEST: {
                x = (double)pos.m_123341_() + bb.f_82288_ - 0.1;
                break;
            }
            case EAST: {
                x = (double)pos.m_123341_() + bb.f_82291_ + 0.1;
                break;
            }
        }
        manager.m_107344_(new TerrainParticle((ClientLevel)world, x, y, z, 0.0, 0.0, 0.0, primaryState, pos).m_107268_(0.2f).m_6569_(0.6f));
        return true;
    }
}

