/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.contraptions.components.structureMovement;

import com.simibubi.create.content.contraptions.components.structureMovement.Contraption;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public abstract class TranslatingContraption
extends Contraption {
    protected Set<BlockPos> cachedColliders;
    protected Direction cachedColliderDirection;

    public Set<BlockPos> getColliders(Level world, Direction movementDirection) {
        if (this.getBlocks() == null) {
            return Collections.emptySet();
        }
        if (this.cachedColliders == null || this.cachedColliderDirection != movementDirection) {
            this.cachedColliders = new HashSet<BlockPos>();
            this.cachedColliderDirection = movementDirection;
            for (StructureTemplate.StructureBlockInfo info : this.getBlocks().values()) {
                BlockPos offsetPos = info.f_74675_.m_142300_(movementDirection);
                if (info.f_74676_.m_60812_((BlockGetter)world, offsetPos).m_83281_() || this.getBlocks().containsKey(offsetPos) && !this.getBlocks().get((Object)offsetPos).f_74676_.m_60812_((BlockGetter)world, offsetPos).m_83281_()) continue;
                this.cachedColliders.add(info.f_74675_);
            }
        }
        return this.cachedColliders;
    }

    @Override
    public void removeBlocksFromWorld(Level world, BlockPos offset) {
        int count = this.blocks.size();
        super.removeBlocksFromWorld(world, offset);
        if (count != this.blocks.size()) {
            this.cachedColliders = null;
        }
    }

    @Override
    public boolean canBeStabilized(Direction facing, BlockPos localPos) {
        return false;
    }
}

