/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.curiosities.weapons;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileRenderMode;
import com.simibubi.create.content.curiosities.weapons.PotatoProjectileTypeManager;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IRegistryDelegate;

public class PotatoCannonProjectileType {
    private Set<IRegistryDelegate<Item>> items = new HashSet<IRegistryDelegate<Item>>();
    private int reloadTicks = 10;
    private int damage = 1;
    private int split = 1;
    private float knockback = 1.0f;
    private float drag = 0.99f;
    private float velocityMultiplier = 1.0f;
    private float gravityMultiplier = 1.0f;
    private float soundPitch = 1.0f;
    private boolean sticky = false;
    private PotatoProjectileRenderMode renderMode = PotatoProjectileRenderMode.Billboard.INSTANCE;
    private Predicate<EntityHitResult> preEntityHit = e -> false;
    private Predicate<EntityHitResult> onEntityHit = e -> false;
    private BiPredicate<LevelAccessor, BlockHitResult> onBlockHit = (w, ray) -> false;

    protected PotatoCannonProjectileType() {
    }

    public Set<IRegistryDelegate<Item>> getItems() {
        return this.items;
    }

    public int getReloadTicks() {
        return this.reloadTicks;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getSplit() {
        return this.split;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public float getDrag() {
        return this.drag;
    }

    public float getVelocityMultiplier() {
        return this.velocityMultiplier;
    }

    public float getGravityMultiplier() {
        return this.gravityMultiplier;
    }

    public float getSoundPitch() {
        return this.soundPitch;
    }

    public boolean isSticky() {
        return this.sticky;
    }

    public PotatoProjectileRenderMode getRenderMode() {
        return this.renderMode;
    }

    public boolean preEntityHit(EntityHitResult ray) {
        return this.preEntityHit.test(ray);
    }

    public boolean onEntityHit(EntityHitResult ray) {
        return this.onEntityHit.test(ray);
    }

    public boolean onBlockHit(LevelAccessor world, BlockHitResult ray) {
        return this.onBlockHit.test(world, ray);
    }

    public static PotatoCannonProjectileType fromJson(JsonObject object) {
        PotatoCannonProjectileType type = new PotatoCannonProjectileType();
        try {
            JsonElement itemsElement = object.get("items");
            if (itemsElement != null && itemsElement.isJsonArray()) {
                for (JsonElement element : itemsElement.getAsJsonArray()) {
                    JsonPrimitive primitive2;
                    if (!element.isJsonPrimitive() || !(primitive2 = element.getAsJsonPrimitive()).isString()) continue;
                    try {
                        Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(primitive2.getAsString()));
                        if (item == null) continue;
                        type.items.add((IRegistryDelegate<Item>)item.delegate);
                    }
                    catch (ResourceLocationException resourceLocationException) {}
                }
            }
            PotatoCannonProjectileType.parseJsonPrimitive(object, "reload_ticks", JsonPrimitive::isNumber, primitive -> {
                type.reloadTicks = primitive.getAsInt();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "damage", JsonPrimitive::isNumber, primitive -> {
                type.damage = primitive.getAsInt();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "split", JsonPrimitive::isNumber, primitive -> {
                type.split = primitive.getAsInt();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "knockback", JsonPrimitive::isNumber, primitive -> {
                type.knockback = primitive.getAsFloat();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "drag", JsonPrimitive::isNumber, primitive -> {
                type.drag = primitive.getAsFloat();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "velocity_multiplier", JsonPrimitive::isNumber, primitive -> {
                type.velocityMultiplier = primitive.getAsFloat();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "gravity_multiplier", JsonPrimitive::isNumber, primitive -> {
                type.gravityMultiplier = primitive.getAsFloat();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "sound_pitch", JsonPrimitive::isNumber, primitive -> {
                type.soundPitch = primitive.getAsFloat();
            });
            PotatoCannonProjectileType.parseJsonPrimitive(object, "sticky", JsonPrimitive::isBoolean, primitive -> {
                type.sticky = primitive.getAsBoolean();
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        return type;
    }

    private static void parseJsonPrimitive(JsonObject object, String key, Predicate<JsonPrimitive> predicate, Consumer<JsonPrimitive> consumer) {
        JsonPrimitive primitive;
        JsonElement element = object.get(key);
        if (element != null && element.isJsonPrimitive() && predicate.test(primitive = element.getAsJsonPrimitive())) {
            consumer.accept(primitive);
        }
    }

    public static void toBuffer(PotatoCannonProjectileType type, FriendlyByteBuf buffer) {
        buffer.m_130130_(type.items.size());
        for (IRegistryDelegate<Item> delegate : type.items) {
            buffer.m_130085_(delegate.name());
        }
        buffer.writeInt(type.reloadTicks);
        buffer.writeInt(type.damage);
        buffer.writeInt(type.split);
        buffer.writeFloat(type.knockback);
        buffer.writeFloat(type.drag);
        buffer.writeFloat(type.velocityMultiplier);
        buffer.writeFloat(type.gravityMultiplier);
        buffer.writeFloat(type.soundPitch);
        buffer.writeBoolean(type.sticky);
    }

    public static PotatoCannonProjectileType fromBuffer(FriendlyByteBuf buffer) {
        PotatoCannonProjectileType type = new PotatoCannonProjectileType();
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(buffer.m_130281_());
            if (item == null) continue;
            type.items.add((IRegistryDelegate<Item>)item.delegate);
        }
        type.reloadTicks = buffer.readInt();
        type.damage = buffer.readInt();
        type.split = buffer.readInt();
        type.knockback = buffer.readFloat();
        type.drag = buffer.readFloat();
        type.velocityMultiplier = buffer.readFloat();
        type.gravityMultiplier = buffer.readFloat();
        type.soundPitch = buffer.readFloat();
        type.sticky = buffer.readBoolean();
        return type;
    }

    public static class Builder {
        protected ResourceLocation id;
        protected PotatoCannonProjectileType result;

        public Builder(ResourceLocation id) {
            this.id = id;
            this.result = new PotatoCannonProjectileType();
        }

        public Builder reloadTicks(int reload) {
            this.result.reloadTicks = reload;
            return this;
        }

        public Builder damage(int damage) {
            this.result.damage = damage;
            return this;
        }

        public Builder splitInto(int split) {
            this.result.split = split;
            return this;
        }

        public Builder knockback(float knockback) {
            this.result.knockback = knockback;
            return this;
        }

        public Builder drag(float drag) {
            this.result.drag = drag;
            return this;
        }

        public Builder velocity(float velocity) {
            this.result.velocityMultiplier = velocity;
            return this;
        }

        public Builder gravity(float modifier) {
            this.result.gravityMultiplier = modifier;
            return this;
        }

        public Builder soundPitch(float pitch) {
            this.result.soundPitch = pitch;
            return this;
        }

        public Builder sticky() {
            this.result.sticky = true;
            return this;
        }

        public Builder renderMode(PotatoProjectileRenderMode renderMode) {
            this.result.renderMode = renderMode;
            return this;
        }

        public Builder renderBillboard() {
            this.renderMode(PotatoProjectileRenderMode.Billboard.INSTANCE);
            return this;
        }

        public Builder renderTumbling() {
            this.renderMode(PotatoProjectileRenderMode.Tumble.INSTANCE);
            return this;
        }

        public Builder renderTowardMotion(int spriteAngle, float spin) {
            this.renderMode(new PotatoProjectileRenderMode.TowardMotion(spriteAngle, spin));
            return this;
        }

        public Builder preEntityHit(Predicate<EntityHitResult> callback) {
            this.result.preEntityHit = callback;
            return this;
        }

        public Builder onEntityHit(Predicate<EntityHitResult> callback) {
            this.result.onEntityHit = callback;
            return this;
        }

        public Builder onBlockHit(BiPredicate<LevelAccessor, BlockHitResult> callback) {
            this.result.onBlockHit = callback;
            return this;
        }

        public Builder addItems(ItemLike ... items) {
            for (ItemLike provider : items) {
                this.result.items.add((IRegistryDelegate<Item>)provider.m_5456_().delegate);
            }
            return this;
        }

        public PotatoCannonProjectileType register() {
            PotatoProjectileTypeManager.registerBuiltinType(this.id, this.result);
            return this.result;
        }

        public PotatoCannonProjectileType registerAndAssign(ItemLike ... items) {
            this.addItems(items);
            this.register();
            return this.result;
        }
    }
}

