/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.logistics.block.display.DisplayLinkBlock;
import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.DisplayLinkTileEntity;
import com.simibubi.create.content.logistics.block.display.source.AccumulatedItemCountDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.foundation.gui.ModularGuiLineBuilder;
import com.simibubi.create.foundation.utility.Lang;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemThoughputDisplaySource
extends AccumulatedItemCountDisplaySource {
    static final int POOL_SIZE = 10;

    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        CompoundTag conf = context.sourceConfig();
        if (conf.m_128441_("Inactive")) {
            return new TextComponent("0");
        }
        double interval = 20.0 * Math.pow(60.0, conf.m_128451_("Interval"));
        double rate = (double)conf.m_128457_("Rate") * interval;
        if (rate > 0.0) {
            int lastAmount;
            double timeBetweenStacks;
            long previousTime = conf.m_128454_("LastReceived");
            long gameTime = context.te().m_58904_().m_46467_();
            int diff = (int)(gameTime - previousTime);
            if (diff > 0 && (double)diff > (timeBetweenStacks = (double)(lastAmount = conf.m_128451_("LastReceivedAmount")) / rate) * 2.0) {
                conf.m_128379_("Inactive", true);
            }
        }
        return Lang.number(rate).component();
    }

    @Override
    public void itemReceived(DisplayLinkTileEntity te, int amount) {
        if (te.m_58900_().m_61145_((Property)DisplayLinkBlock.POWERED).orElse(true).booleanValue()) {
            return;
        }
        CompoundTag conf = te.getSourceConfig();
        long gameTime = te.m_58904_().m_46467_();
        if (!conf.m_128441_("LastReceived")) {
            conf.m_128356_("LastReceived", gameTime);
            return;
        }
        long previousTime = conf.m_128454_("LastReceived");
        ListTag rates = conf.m_128437_("PrevRates", 5);
        if (rates.size() != 10) {
            rates = new ListTag();
            for (int i = 0; i < 10; ++i) {
                rates.add((Object)FloatTag.m_128566_((float)-1.0f));
            }
        }
        int poolIndex = conf.m_128451_("Index") % 10;
        rates.set(poolIndex, (Tag)FloatTag.m_128566_((float)((float)((double)amount / (double)(gameTime - previousTime)))));
        float rate = 0.0f;
        int validIntervals = 0;
        for (int i = 0; i < 10; ++i) {
            float pooledRate = rates.m_128775_(i);
            if (!(pooledRate >= 0.0f)) continue;
            rate += pooledRate;
            ++validIntervals;
        }
        conf.m_128473_("Rate");
        if (validIntervals > 0) {
            conf.m_128350_("Rate", rate /= (float)validIntervals);
        }
        conf.m_128473_("Inactive");
        conf.m_128405_("LastReceivedAmount", amount);
        conf.m_128356_("LastReceived", gameTime);
        conf.m_128405_("Index", poolIndex + 1);
        conf.m_128365_("PrevRates", (Tag)rates);
        te.updateGatheredData();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void initConfigurationWidgets(DisplayLinkContext context, ModularGuiLineBuilder builder, boolean isFirstLine) {
        super.initConfigurationWidgets(context, builder, isFirstLine);
        if (isFirstLine) {
            return;
        }
        builder.addSelectionScrollInput(0, 80, (si, l) -> si.forOptions(Lang.translatedOptions("display_source.item_throughput.interval", "second", "minute", "hour")).titled((MutableComponent)Lang.translateDirect("display_source.item_throughput.interval", new Object[0])), "Interval");
    }

    @Override
    protected String getTranslationKey() {
        return "item_throughput";
    }
}

