/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.block.display.source;

import com.simibubi.create.content.logistics.block.display.DisplayLinkContext;
import com.simibubi.create.content.logistics.block.display.source.SingleLineDisplaySource;
import com.simibubi.create.content.logistics.block.display.target.DisplayTargetStats;
import com.simibubi.create.content.logistics.trains.entity.Train;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.GlobalStation;
import com.simibubi.create.content.logistics.trains.management.edgePoint.station.StationTileEntity;
import com.simibubi.create.content.logistics.trains.management.schedule.Schedule;
import com.simibubi.create.content.logistics.trains.management.schedule.ScheduleRuntime;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.entity.BlockEntity;

public class TrainStatusDisplaySource
extends SingleLineDisplaySource {
    @Override
    protected MutableComponent provideLine(DisplayLinkContext context, DisplayTargetStats stats) {
        BlockEntity blockEntity = context.getSourceTE();
        if (!(blockEntity instanceof StationTileEntity)) {
            return EMPTY_LINE;
        }
        StationTileEntity observerTE = (StationTileEntity)blockEntity;
        GlobalStation observer = observerTE.getStation();
        if (observer == null) {
            return EMPTY_LINE;
        }
        Train currentTrain = observer.getPresentTrain();
        if (currentTrain == null) {
            return EMPTY_LINE;
        }
        ScheduleRuntime runtime = currentTrain.runtime;
        Schedule schedule = runtime.getSchedule();
        if (schedule == null) {
            return EMPTY_LINE;
        }
        if (runtime.paused) {
            return EMPTY_LINE;
        }
        if (runtime.state != ScheduleRuntime.State.POST_TRANSIT) {
            return EMPTY_LINE;
        }
        if (runtime.currentEntry == schedule.entries.size() - 1 && !schedule.cyclic) {
            return EMPTY_LINE;
        }
        return runtime.getWaitingStatus(context.level());
    }

    @Override
    protected boolean allowsLabeling(DisplayLinkContext context) {
        return false;
    }

    @Override
    protected String getTranslationKey() {
        return "train_status";
    }
}

