/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.logistics.trains.track;

import com.jozufozu.flywheel.util.transform.TransformStack;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllShapes;
import com.simibubi.create.content.logistics.trains.BezierConnection;
import com.simibubi.create.content.logistics.trains.track.BezierTrackPointLocation;
import com.simibubi.create.content.logistics.trains.track.TrackBlock;
import com.simibubi.create.content.logistics.trains.track.TrackRenderer;
import com.simibubi.create.content.logistics.trains.track.TrackShape;
import com.simibubi.create.content.logistics.trains.track.TrackTileEntity;
import com.simibubi.create.content.logistics.trains.track.TrackVoxelShapes;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.Iterate;
import com.simibubi.create.foundation.utility.RaycastHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.WorldAttached;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class TrackBlockOutline {
    public static WorldAttached<Map<BlockPos, TrackTileEntity>> TRACKS_WITH_TURNS = new WorldAttached(w -> new HashMap());
    public static BezierPointSelection result;
    private static final VoxelShape LONG_CROSS;
    private static final VoxelShape LONG_ORTHO;
    private static final VoxelShape LONG_ORTHO_OFFSET;

    public static void pickCurves() {
        Minecraft mc = Minecraft.m_91087_();
        Entity entity = mc.f_91075_;
        if (!(entity instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer player = (LocalPlayer)entity;
        if (mc.f_91073_ == null) {
            return;
        }
        Vec3 origin = player.m_20299_(AnimationTickHolder.getPartialTicks((LevelAccessor)mc.f_91073_));
        double maxRange = mc.f_91077_ == null ? Double.MAX_VALUE : mc.f_91077_.m_82450_().m_82557_(origin);
        result = null;
        AttributeInstance range = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get());
        Vec3 target = RaycastHelper.getTraceTarget((Player)player, Math.min(maxRange, range.m_22135_()) + 1.0, origin);
        Map<BlockPos, TrackTileEntity> turns = TRACKS_WITH_TURNS.get((LevelAccessor)mc.f_91073_);
        for (TrackTileEntity te : turns.values()) {
            for (BezierConnection bc : te.connections.values()) {
                AABB bounds;
                if (!bc.isPrimary() || !(bounds = bc.getBounds()).m_82390_(origin) && bounds.m_82371_(origin, target).isEmpty()) continue;
                float[] stepLUT = bc.getStepLUT();
                int segments = (int)(bc.getLength() * 2.0);
                AABB segmentBounds = AllShapes.TRACK_ORTHO.get(Direction.SOUTH).m_83215_();
                segmentBounds = segmentBounds.m_82386_(-0.5, segmentBounds.m_82376_() / -2.0, -0.5);
                int bestSegment = -1;
                double bestDistance = Double.MAX_VALUE;
                double newMaxRange = maxRange;
                for (int i = 0; i < stepLUT.length - 2; ++i) {
                    double distanceToSqr;
                    float t = stepLUT[i] * (float)i / (float)segments;
                    float t1 = stepLUT[i + 1] * (float)(i + 1) / (float)segments;
                    float t2 = stepLUT[i + 2] * (float)(i + 2) / (float)segments;
                    Vec3 v1 = bc.getPosition(t);
                    Vec3 v2 = bc.getPosition(t2);
                    Vec3 diff = v2.m_82546_(v1);
                    Vec3 angles = TrackRenderer.getModelAngles(bc.getNormal(t1), diff);
                    Vec3 anchor = v1.m_82549_(diff.m_82490_(0.5));
                    Vec3 localOrigin = origin.m_82546_(anchor);
                    Vec3 localDirection = target.m_82546_(origin);
                    localOrigin = VecHelper.rotate(localOrigin, AngleHelper.deg(-angles.f_82479_), Direction.Axis.X);
                    localOrigin = VecHelper.rotate(localOrigin, AngleHelper.deg(-angles.f_82480_), Direction.Axis.Y);
                    localDirection = VecHelper.rotate(localDirection, AngleHelper.deg(-angles.f_82479_), Direction.Axis.X);
                    Optional clip = segmentBounds.m_82371_(localOrigin, localOrigin.m_82549_(localDirection = VecHelper.rotate(localDirection, AngleHelper.deg(-angles.f_82480_), Direction.Axis.Y)));
                    if (clip.isEmpty() || bestSegment != -1 && bestDistance < ((Vec3)clip.get()).m_82531_(0.0, 0.25, 0.0) || (distanceToSqr = ((Vec3)clip.get()).m_82557_(localOrigin)) > maxRange) continue;
                    bestSegment = i;
                    newMaxRange = distanceToSqr;
                    bestDistance = ((Vec3)clip.get()).m_82531_(0.0, 0.25, 0.0);
                    BezierTrackPointLocation location = new BezierTrackPointLocation(bc.getKey(), i);
                    result = new BezierPointSelection(te, location, anchor, angles, diff.m_82541_());
                }
                if (bestSegment == -1) continue;
                maxRange = newMaxRange;
            }
        }
        if (result == null) {
            return;
        }
        if (mc.f_91077_ != null && mc.f_91077_.m_6662_() != HitResult.Type.MISS) {
            Vec3 priorLoc = mc.f_91077_.m_82450_();
            mc.f_91077_ = BlockHitResult.m_82426_((Vec3)priorLoc, (Direction)Direction.UP, (BlockPos)new BlockPos(priorLoc));
        }
    }

    public static void drawCurveSelection(PoseStack ms, MultiBufferSource buffer) {
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        BezierPointSelection result = TrackBlockOutline.result;
        if (result == null) {
            return;
        }
        VertexConsumer vb = buffer.m_6299_(RenderType.m_110504_());
        Vec3 vec = result.vec();
        Vec3 angles = result.angles();
        ((TransformStack)((TransformStack)((TransformStack)((TransformStack)TransformStack.cast((PoseStack)ms).pushPose()).translate(vec.f_82479_, vec.f_82480_ + 0.125, vec.f_82481_)).rotateYRadians(angles.f_82480_)).rotateXRadians(angles.f_82479_)).translate(-0.5, -0.125, -0.5);
        boolean holdingTrack = AllBlocks.TRACK.isIn(Minecraft.m_91087_().f_91074_.m_21205_());
        TrackBlockOutline.renderShape(AllShapes.TRACK_ORTHO.get(Direction.SOUTH), ms, vb, holdingTrack ? Boolean.valueOf(false) : null);
        ms.m_85849_();
    }

    @SubscribeEvent
    public static void drawCustomBlockSelection(DrawSelectionEvent.HighlightBlock event) {
        Minecraft mc = Minecraft.m_91087_();
        BlockHitResult target = event.getTarget();
        BlockPos pos = target.m_82425_();
        BlockState blockstate = mc.f_91073_.m_8055_(pos);
        if (!(blockstate.m_60734_() instanceof TrackBlock)) {
            return;
        }
        if (!mc.f_91073_.m_6857_().m_61937_(pos)) {
            return;
        }
        VertexConsumer vb = event.getMultiBufferSource().m_6299_(RenderType.m_110504_());
        Vec3 camPos = event.getCamera().m_90583_();
        PoseStack ms = event.getPoseStack();
        ms.m_85836_();
        ms.m_85837_((double)pos.m_123341_() - camPos.f_82479_, (double)pos.m_123342_() - camPos.f_82480_, (double)pos.m_123343_() - camPos.f_82481_);
        boolean holdingTrack = AllBlocks.TRACK.isIn(Minecraft.m_91087_().f_91074_.m_21205_());
        TrackShape shape = (TrackShape)((Object)blockstate.m_61143_(TrackBlock.SHAPE));
        boolean isJunction = shape.isJunction();
        TrackBlockOutline.walkShapes(shape, TransformStack.cast((PoseStack)ms), s -> {
            TrackBlockOutline.renderShape(s, ms, vb, holdingTrack ? Boolean.valueOf(!isJunction) : null);
            event.setCanceled(true);
        });
        ms.m_85849_();
    }

    private static void renderShape(VoxelShape s, PoseStack ms, VertexConsumer vb, Boolean valid) {
        PoseStack.Pose transform = ms.m_85850_();
        s.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            float xDiff = (float)(x2 - x1);
            float yDiff = (float)(y2 - y1);
            float zDiff = (float)(z2 - z1);
            float length = Mth.m_14116_((float)(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff));
            xDiff /= length;
            yDiff /= length;
            zDiff /= length;
            float r = 0.0f;
            float g = 0.0f;
            float b = 0.0f;
            if (valid != null && valid.booleanValue()) {
                g = 1.0f;
                b = 1.0f;
                r = 1.0f;
            }
            if (valid != null && !valid.booleanValue()) {
                r = 1.0f;
                b = 0.125f;
                g = 0.25f;
            }
            vb.m_85982_(transform.m_85861_(), (float)x1, (float)y1, (float)z1).m_85950_(r, g, b, 0.4f).m_85977_(transform.m_85864_(), xDiff, yDiff, zDiff).m_5752_();
            vb.m_85982_(transform.m_85861_(), (float)x2, (float)y2, (float)z2).m_85950_(r, g, b, 0.4f).m_85977_(transform.m_85864_(), xDiff, yDiff, zDiff).m_5752_();
        });
    }

    private static void walkShapes(TrackShape shape, TransformStack msr, Consumer<VoxelShape> renderer) {
        float angle45 = 0.7853982f;
        if (shape == TrackShape.XO || shape == TrackShape.CR_NDX || shape == TrackShape.CR_PDX) {
            renderer.accept(AllShapes.TRACK_ORTHO.get(Direction.EAST));
        } else if (shape == TrackShape.ZO || shape == TrackShape.CR_NDZ || shape == TrackShape.CR_PDZ) {
            renderer.accept(AllShapes.TRACK_ORTHO.get(Direction.SOUTH));
        }
        if (shape.isPortal()) {
            for (Direction d : Iterate.horizontalDirections) {
                if (TrackShape.asPortal(d) != shape) continue;
                msr.rotateCentered(Direction.UP, AngleHelper.rad(AngleHelper.horizontalAngle(d)));
                renderer.accept(LONG_ORTHO_OFFSET);
                return;
            }
        }
        if (shape == TrackShape.PD || shape == TrackShape.CR_PDX || shape == TrackShape.CR_PDZ) {
            msr.rotateCentered(Direction.UP, angle45);
            renderer.accept(LONG_ORTHO);
        } else if (shape == TrackShape.ND || shape == TrackShape.CR_NDX || shape == TrackShape.CR_NDZ) {
            msr.rotateCentered(Direction.UP, -0.7853982f);
            renderer.accept(LONG_ORTHO);
        }
        if (shape == TrackShape.CR_O) {
            renderer.accept(AllShapes.TRACK_CROSS);
        } else if (shape == TrackShape.CR_D) {
            msr.rotateCentered(Direction.UP, angle45);
            renderer.accept(LONG_CROSS);
        }
        if (shape != TrackShape.AE && shape != TrackShape.AN && shape != TrackShape.AW && shape != TrackShape.AS) {
            return;
        }
        msr.translate(0.0, 1.0, 0.0);
        msr.rotateCentered(Direction.UP, (float)Math.PI - AngleHelper.rad(shape.getModelRotation()));
        msr.rotateXRadians((double)angle45);
        msr.translate(0.0, -0.1875, 0.0625);
        renderer.accept(LONG_ORTHO);
    }

    static {
        LONG_CROSS = Shapes.m_83110_((VoxelShape)TrackVoxelShapes.longOrthogonalZ(), (VoxelShape)TrackVoxelShapes.longOrthogonalX());
        LONG_ORTHO = TrackVoxelShapes.longOrthogonalZ();
        LONG_ORTHO_OFFSET = TrackVoxelShapes.longOrthogonalZOffset();
    }

    public record BezierPointSelection(TrackTileEntity te, BezierTrackPointLocation loc, Vec3 vec, Vec3 angles, Vec3 direction) {
    }
}

