/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.client.ModLayerDefinitions;
import io.github.lightman314.lightmanscurrency.client.colors.TicketColor;
import io.github.lightman314.lightmanscurrency.client.renderer.entity.layers.WalletLayer;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.TicketSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.WalletSlot;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientModEvents {
    @SubscribeEvent
    public static void registerItemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().m_92689_((ItemColor)new TicketColor(), new ItemLike[]{ModItems.TICKET, ModItems.TICKET_MASTER});
    }

    @SubscribeEvent
    public static void stitchTextures(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_() == InventoryMenu.f_39692_) {
            event.addSprite(CoinSlot.EMPTY_COIN_SLOT);
            event.addSprite(TicketSlot.EMPTY_TICKET_SLOT);
            event.addSprite(WalletSlot.EMPTY_WALLET_SLOT);
            event.addSprite(ItemRenderUtil.EMPTY_SLOT_BG);
            event.addSprite(UpgradeInputSlot.EMPTY_UPGRADE_SLOT);
        }
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ModLayerDefinitions.WALLET, WalletLayer::createLayer);
    }

    @SubscribeEvent
    public static void addLayers(EntityRenderersEvent.AddLayers event) {
        ClientModEvents.addWalletLayer(event, "default");
        ClientModEvents.addWalletLayer(event, "slim");
    }

    private static void addWalletLayer(EntityRenderersEvent.AddLayers event, String skin) {
        LivingEntityRenderer renderer = event.getSkin(skin);
        if (renderer instanceof LivingEntityRenderer) {
            LivingEntityRenderer livingRenderer = renderer;
            livingRenderer.m_115326_(new WalletLayer(livingRenderer));
        }
    }
}

