/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types;

import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemTradeNotification
extends Notification {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "item_trade");
    TraderCategory traderData;
    ItemTradeData.ItemTradeType tradeType;
    List<ItemData> items;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    String customer;

    public ItemTradeNotification(ItemTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData) {
        this.traderData = traderData;
        this.tradeType = trade.getTradeType();
        this.items = new ArrayList<ItemData>();
        this.items.add(new ItemData(trade.getSellItem(0), trade.isPurchase() ? "" : trade.getCustomName(0)));
        this.items.add(new ItemData(trade.getSellItem(1), trade.isPurchase() ? "" : trade.getCustomName(1)));
        if (trade.isBarter()) {
            this.items.add(new ItemData(trade.getBarterItem(0), ""));
            this.items.add(new ItemData(trade.getBarterItem(1), ""));
        } else {
            this.cost = cost;
        }
        this.customer = customer.lastKnownName();
    }

    public ItemTradeNotification(CompoundTag compound) {
        this.load(compound);
    }

    @Override
    protected ResourceLocation getType() {
        return TYPE;
    }

    @Override
    public Notification.Category getCategory() {
        return this.traderData;
    }

    @Override
    public Component getMessage() {
        Component cost;
        TranslatableComponent boughtText = new TranslatableComponent("log.shoplog." + this.tradeType.name().toLowerCase());
        Component itemText = this.getItemNames(this.items.get(0), this.items.get(1));
        if (this.tradeType == ItemTradeData.ItemTradeType.BARTER) {
            cost = itemText;
            itemText = this.getItemNames(this.items.get(2), this.items.get(3));
        } else {
            cost = new TextComponent(this.cost.getString("0"));
        }
        return new TranslatableComponent("notifications.message.item_trade", new Object[]{this.customer, boughtText, itemText, cost});
    }

    private Component getItemNames(ItemData item1, ItemData item2) {
        if (item1.isEmpty && item2.isEmpty) {
            return new TextComponent("ERROR");
        }
        if (item2.isEmpty) {
            return item1.format();
        }
        if (item1.isEmpty) {
            return item2.format();
        }
        return item1.formatWith(item2);
    }

    @Override
    protected void saveAdditional(CompoundTag compound) {
        compound.m_128365_("TraderInfo", (Tag)this.traderData.save());
        compound.m_128405_("TradeType", this.tradeType.index);
        ListTag itemList = new ListTag();
        for (ItemData item : this.items) {
            itemList.add((Object)item.save());
        }
        compound.m_128365_("Items", (Tag)itemList);
        if (this.tradeType != ItemTradeData.ItemTradeType.BARTER) {
            this.cost.writeToNBT(compound, "Price");
        }
        compound.m_128359_("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(CompoundTag compound) {
        this.traderData = new TraderCategory(compound.m_128469_("TraderInfo"));
        this.tradeType = ItemTradeData.ItemTradeType.fromIndex(compound.m_128451_("TradeType"));
        ListTag itemList = compound.m_128437_("Items", 10);
        this.items = new ArrayList<ItemData>();
        for (int i = 0; i < itemList.size(); ++i) {
            this.items.add(new ItemData(itemList.m_128728_(i)));
        }
        if (this.tradeType != ItemTradeData.ItemTradeType.BARTER) {
            this.cost.readFromNBT(compound, "Price");
        }
        this.customer = compound.m_128461_("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof ItemTradeNotification) {
            ItemTradeNotification itn = (ItemTradeNotification)other;
            if (!itn.traderData.matches(this.traderData)) {
                return false;
            }
            if (itn.tradeType != this.tradeType) {
                return false;
            }
            if (itn.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); ++i) {
                ItemData i1 = this.items.get(i);
                ItemData i2 = itn.items.get(i);
                if (!i1.itemName.getString().equals(i2.itemName.getString())) {
                    return false;
                }
                if (i1.count == i2.count) continue;
                return false;
            }
            if (itn.cost.getRawValue() != this.cost.getRawValue()) {
                return false;
            }
            return itn.customer.equals(this.customer);
        }
        return false;
    }

    public static class ItemData {
        final boolean isEmpty;
        final Component itemName;
        final int count;

        public ItemData(ItemStack item) {
            this(item, "");
        }

        public ItemData(ItemStack item, String customName) {
            this.isEmpty = item.m_41619_();
            if (this.isEmpty) {
                this.itemName = new TextComponent("");
                this.count = 0;
                return;
            }
            this.itemName = customName.isEmpty() ? item.m_41786_() : new TextComponent(customName);
            this.count = item.m_41613_();
        }

        public ItemData(CompoundTag compound) {
            this.isEmpty = compound.m_128441_("Empty");
            if (this.isEmpty) {
                this.itemName = new TextComponent("");
                this.count = 0;
                return;
            }
            this.itemName = Component.Serializer.m_130701_((String)compound.m_128461_("Name"));
            this.count = compound.m_128451_("Count");
        }

        public CompoundTag save() {
            CompoundTag compound = new CompoundTag();
            if (this.isEmpty) {
                compound.m_128379_("Empty", true);
                return compound;
            }
            compound.m_128359_("Name", Component.Serializer.m_130703_((Component)this.itemName));
            compound.m_128405_("Count", this.count);
            return compound;
        }

        public Component format() {
            return new TranslatableComponent("log.shoplog.item.itemformat", new Object[]{this.count, this.itemName});
        }

        public Component formatWith(Component other) {
            return new TranslatableComponent("log.shoplog.and", new Object[]{this.format(), other});
        }

        public Component formatWith(ItemData other) {
            return new TranslatableComponent("log.shoplog.and", new Object[]{this.format(), other.format()});
        }
    }
}

