/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.universal_traders;

import com.google.common.base.Supplier;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.PersistentAuctionData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.events.NotificationEvent;
import io.github.lightman314.lightmanscurrency.events.UniversalTraderEvent;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageInitializeClientBank;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageUpdateClientBank;
import io.github.lightman314.lightmanscurrency.network.message.bank.SPacketSyncSelectedBankAccount;
import io.github.lightman314.lightmanscurrency.network.message.command.MessageSyncAdminList;
import io.github.lightman314.lightmanscurrency.network.message.notifications.MessageClientNotification;
import io.github.lightman314.lightmanscurrency.network.message.notifications.MessageUpdateClientNotifications;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageInitializeClientTeams;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageRemoveClientTeam;
import io.github.lightman314.lightmanscurrency.network.message.teams.MessageUpdateClientTeam;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageClearClientTraders;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageRemoveClientTrader;
import io.github.lightman314.lightmanscurrency.network.message.universal_trader.MessageUpdateClientData;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="lightmanscurrency")
public class TradingOffice
extends SavedData {
    public static final String PERSISTENT_TRADER_FILENAME = "config/lightmanscurrency/persistentTraders.json";
    private static TradingOffice activeOffice = null;
    private static final Map<ResourceLocation, Supplier<? extends UniversalTraderData>> registeredDeserializers = Maps.newHashMap();
    private static final String DATA_NAME = "lightmanscurrency_trading_office";
    private static List<UUID> adminPlayers = new ArrayList<UUID>();
    private Map<UUID, UniversalTraderData> persistentTraderMap = new HashMap<UUID, UniversalTraderData>();
    private Map<UUID, String> persistentTraderIDs = new HashMap<UUID, String>();
    private List<PersistentAuctionData> persistentAuctionData = new ArrayList<PersistentAuctionData>();
    private Map<UUID, UniversalTraderData> universalTraderMap = new HashMap<UUID, UniversalTraderData>();
    private Map<UUID, Team> playerTeams = new HashMap<UUID, Team>();
    private Map<UUID, BankAccount> playerBankAccounts = new HashMap<UUID, BankAccount>();
    private Map<UUID, NotificationData> playerNotifications = new HashMap<UUID, NotificationData>();
    private Map<UUID, BankAccount.AccountReference> lastSelectedAccounts = new HashMap<UUID, BankAccount.AccountReference>();
    ListTag persistentData = new ListTag();

    public TradingOffice() {
        TradingOffice.cleanOldOffice(this);
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    public TradingOffice(CompoundTag tag) {
        TradingOffice.cleanOldOffice(this);
        this.load(tag);
        this.validateAuctionHouse();
        this.loadPersistentTraders();
    }

    private static void cleanOldOffice(TradingOffice newOffice) {
        if (activeOffice != null) {
            TradingOffice.activeOffice.persistentTraderMap.forEach((id, data) -> data.onRemoved());
            TradingOffice.activeOffice.universalTraderMap.forEach((id, data) -> data.onRemoved());
        }
        activeOffice = newOffice;
    }

    public static void forceValidateAuctionHouse() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).validateAuctionHouse();
        }
    }

    private void validateAuctionHouse() {
        if (!((Boolean)Config.SERVER.enableAuctionHouse.get()).booleanValue()) {
            LightmansCurrency.LogInfo("Will not create or validate the auction house as the auction house is disabled.");
            return;
        }
        AtomicBoolean hasAuctionHouse = new AtomicBoolean(false);
        this.universalTraderMap.forEach((id, data) -> {
            if (data instanceof AuctionHouseTrader) {
                hasAuctionHouse.set(true);
            }
        });
        if (!hasAuctionHouse.get()) {
            AuctionHouseTrader ah = new AuctionHouseTrader();
            ah.getCoreSettings().forceCreative();
            UUID traderID = this.getValidTraderID();
            ah.initTraderID(traderID);
            LightmansCurrency.LogInfo("Successfully created an auction house trader with id '" + traderID + "'!");
            this.universalTraderMap.put(traderID, ah);
            this.m_77762_();
            CompoundTag compound = ah.write(new CompoundTag());
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
        }
    }

    public static final void RegisterDataType(ResourceLocation key, Supplier<? extends UniversalTraderData> source) {
        if (registeredDeserializers.containsKey(key)) {
            LightmansCurrency.LogError("A universal trader type of key " + key + " has already been registered.");
        } else {
            registeredDeserializers.put(key, source);
        }
    }

    public static UniversalTraderData Deserialize(CompoundTag compound) {
        ResourceLocation thisType = new ResourceLocation(compound.m_128461_("type"));
        if (registeredDeserializers.containsKey(thisType)) {
            UniversalTraderData data = (UniversalTraderData)registeredDeserializers.get(thisType).get();
            data.read(compound);
            return data;
        }
        return null;
    }

    public static UniversalTraderData Deserialize(JsonObject json) throws Throwable {
        if (!(json.has("type") && json.get("type").isJsonPrimitive() && json.get("type").getAsJsonPrimitive().isString())) {
            throw new Exception("No string 'type' entry for this trader.");
        }
        ResourceLocation thisType = new ResourceLocation(json.get("type").getAsString());
        if (registeredDeserializers.containsKey(thisType)) {
            UniversalTraderData data = (UniversalTraderData)registeredDeserializers.get(thisType).get();
            data.loadFromJson(json);
            return data;
        }
        throw new Exception("Trader type '" + thisType + "' is undefined.");
    }

    public void load(CompoundTag compound) {
        UUID playerID;
        int i;
        if (compound.m_128425_("UniversalTraders", 9)) {
            this.universalTraderMap.forEach((id, data) -> data.onRemoved());
            this.universalTraderMap.clear();
            ListTag universalTraderDataList = compound.m_128437_("UniversalTraders", 10);
            universalTraderDataList.forEach(nbt -> {
                CompoundTag traderNBT = (CompoundTag)nbt;
                UniversalTraderData data = TradingOffice.Deserialize(traderNBT);
                if (data != null) {
                    this.universalTraderMap.put(data.getTraderID(), data);
                }
            });
        }
        if (compound.m_128425_("Teams", 9)) {
            this.playerTeams.clear();
            ListTag teamList = compound.m_128437_("Teams", 10);
            for (i = 0; i < teamList.size(); ++i) {
                Team team = Team.load(teamList.m_128728_(i));
                if (team == null) continue;
                this.playerTeams.put(team.getID(), team);
            }
        }
        if (compound.m_128425_("BankAccounts", 9)) {
            this.playerBankAccounts.clear();
            ListTag bankAccountList = compound.m_128437_("BankAccounts", 10);
            for (i = 0; i < bankAccountList.size(); ++i) {
                CompoundTag accountCompound = bankAccountList.m_128728_(i);
                try {
                    UUID owner = accountCompound.m_128342_("Player");
                    BankAccount bankAccount = new BankAccount(() -> TradingOffice.MarkBankAccountDirty(owner), accountCompound);
                    if (owner == null || bankAccount == null) continue;
                    bankAccount.setNotificationConsumer(BankAccount.generateNotificationAcceptor(owner));
                    this.playerBankAccounts.put(owner, bankAccount);
                    bankAccount.updateOwnersName(PlayerReference.of(owner, bankAccount.getOwnersName()).lastKnownName());
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (compound.m_128425_("PersistentTraderData", 9)) {
            this.persistentData = compound.m_128437_("PersistentTraderData", 10);
        }
        if (compound.m_128425_("PersistentTraderIDs", 9)) {
            this.persistentTraderIDs.clear();
            ListTag persistentIDs = compound.m_128437_("PersistentTraderIDs", 10);
            for (i = 0; i < persistentIDs.size(); ++i) {
                try {
                    CompoundTag idData = persistentIDs.m_128728_(i);
                    UUID uuid = idData.m_128342_("UUID");
                    String traderID = idData.m_128461_("TraderID");
                    if (uuid == null || traderID == null) continue;
                    this.persistentTraderIDs.put(uuid, traderID);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (compound.m_128425_("PlayerNotifications", 9)) {
            this.playerNotifications.clear();
            ListTag notificationData = compound.m_128437_("PlayerNotifications", 10);
            for (i = 0; i < notificationData.size(); ++i) {
                CompoundTag notData = notificationData.m_128728_(i);
                if (!notData.m_128441_("Player")) continue;
                playerID = notData.m_128342_("Player");
                NotificationData data2 = NotificationData.loadFrom(notData);
                if (playerID == null || data2 == null) continue;
                this.playerNotifications.put(playerID, data2);
            }
        }
        if (compound.m_128425_("LastSelectedBankAccounts", 9)) {
            this.lastSelectedAccounts.clear();
            ListTag selectedAccounts = compound.m_128437_("LastSelectedBankAccounts", 10);
            for (i = 0; i < selectedAccounts.size(); ++i) {
                CompoundTag accountData = selectedAccounts.m_128728_(i);
                if (!accountData.m_128441_("Player")) continue;
                playerID = accountData.m_128342_("Player");
                BankAccount.AccountReference account = BankAccount.LoadReference(false, accountData);
                if (playerID == null || account == null) continue;
                this.lastSelectedAccounts.put(playerID, account);
            }
        }
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        ListTag universalTraderDataList = new ListTag();
        this.universalTraderMap.forEach((traderID, traderData) -> {
            if (traderData != null) {
                CompoundTag traderNBT = traderData.write(new CompoundTag());
                traderNBT.m_128362_("ID", traderID);
                universalTraderDataList.add((Object)traderNBT);
            }
        });
        compound.m_128365_("UniversalTraders", (Tag)universalTraderDataList);
        ListTag teamList = new ListTag();
        this.playerTeams.forEach((teamID, team) -> {
            if (team != null) {
                teamList.add((Object)team.save());
            }
        });
        compound.m_128365_("Teams", (Tag)teamList);
        ListTag bankAccountList = new ListTag();
        this.playerBankAccounts.forEach((playerID, account) -> {
            CompoundTag accountNBT = account.save();
            accountNBT.m_128362_("Player", playerID);
            bankAccountList.add((Object)accountNBT);
        });
        compound.m_128365_("BankAccounts", (Tag)bankAccountList);
        this.persistentTraderMap.forEach((ID, traderData) -> {
            if (traderData != null && this.persistentTraderIDs.containsKey(ID)) {
                CompoundTag data = traderData.getPersistentData();
                String traderID = this.persistentTraderIDs.get(ID);
                data.m_128359_("traderID", traderID);
                this.setPersistentData(traderID, data);
            }
        });
        compound.m_128365_("PersistentTraderData", (Tag)this.persistentData);
        ListTag persistentTraderIDs = new ListTag();
        this.persistentTraderIDs.forEach((uuid, traderID) -> {
            CompoundTag idData = new CompoundTag();
            idData.m_128362_("UUID", uuid);
            idData.m_128359_("TraderID", traderID);
            persistentTraderIDs.add((Object)idData);
        });
        compound.m_128365_("PersistentTraderIDs", (Tag)persistentTraderIDs);
        ListTag notficationData = new ListTag();
        this.playerNotifications.forEach((uuid, notificationData) -> {
            CompoundTag notData = notificationData.save();
            notData.m_128362_("Player", uuid);
            notficationData.add((Object)notData);
        });
        compound.m_128365_("PlayerNotifications", (Tag)notficationData);
        ListTag selectedAccounts = new ListTag();
        this.lastSelectedAccounts.forEach((uuid, account) -> {
            CompoundTag accountData = account.save();
            accountData.m_128362_("Player", uuid);
            selectedAccounts.add((Object)accountData);
        });
        compound.m_128365_("LastSelectedBankAccounts", (Tag)selectedAccounts);
        return compound;
    }

    public static void reloadPersistentTraders() {
        TradingOffice office = TradingOffice.get(ServerLifecycleHooks.getCurrentServer());
        office.loadPersistentTraders();
        office.resendTraderData();
    }

    private void loadPersistentTraders() {
        File ptf = new File(PERSISTENT_TRADER_FILENAME);
        if (!ptf.exists()) {
            this.createPersistentTraderFile(ptf);
        }
        try {
            JsonObject fileData = GsonHelper.m_13864_((String)Files.readString(ptf.toPath()));
            this.loadPersistentTrader(fileData);
        }
        catch (Throwable e) {
            LightmansCurrency.LogError("Error loading Persistent Traders.", e);
        }
    }

    private void loadPersistentTrader(JsonObject fileData) throws Exception {
        int i;
        ArrayList<String> loadedIDs;
        boolean hadNone = true;
        if (fileData.has("Traders")) {
            hadNone = false;
            this.persistentTraderMap.forEach((id, data) -> data.onRemoved());
            this.persistentTraderMap.clear();
            loadedIDs = new ArrayList<String>();
            JsonArray traderList = fileData.getAsJsonArray("Traders");
            for (i = 0; i < traderList.size(); ++i) {
                try {
                    JsonObject traderTag = traderList.get(i).getAsJsonObject();
                    if (!traderTag.has("id")) {
                        throw new Exception("Trader has no defined id.");
                    }
                    String traderID = traderTag.get("id").getAsString();
                    if (loadedIDs.contains(traderID)) {
                        throw new Exception("Trader with id '" + traderID + "' already exists. Cannot have duplicate ids.");
                    }
                    UniversalTraderData data2 = TradingOffice.Deserialize(traderTag);
                    data2.getCoreSettings().forceCreative();
                    data2.loadPersistentData(this.getPersistentData(traderID));
                    UUID id2 = this.getPersistentTraderUUID(traderID);
                    if (id2 == null) {
                        id2 = this.getValidTraderID();
                        this.persistentTraderIDs.put(id2, traderID);
                        this.m_77762_();
                    }
                    data2.initTraderID(id2);
                    this.persistentTraderMap.put(id2, data2);
                    loadedIDs.add(traderID);
                    LightmansCurrency.LogInfo("Successfully loaded persistent trader '" + traderID + "' with UUID " + id2.toString() + ".");
                    continue;
                }
                catch (Throwable e) {
                    LightmansCurrency.LogError("Error loading Persistent Trader at index " + i, e);
                }
            }
        }
        if (fileData.has("Auctions")) {
            hadNone = false;
            this.persistentAuctionData.clear();
            loadedIDs = new ArrayList();
            JsonArray auctionList = fileData.getAsJsonArray("Auctions");
            for (i = 0; i < auctionList.size(); ++i) {
                try {
                    JsonObject auctionTag = auctionList.get(i).getAsJsonObject();
                    PersistentAuctionData data3 = PersistentAuctionData.load(auctionTag);
                    if (loadedIDs.contains(data3.id)) {
                        throw new Exception("Auction with id '" + data3.id + "' already exists. Cannot have duplicate ids.");
                    }
                    loadedIDs.add(data3.id);
                    this.persistentAuctionData.add(data3);
                    LightmansCurrency.LogInfo("Successfully loaded persistent auction '" + data3.id + "'");
                    continue;
                }
                catch (Throwable e) {
                    LightmansCurrency.LogError("Error loading Persistent Auction at index " + i, e);
                }
            }
        }
        if (hadNone) {
            throw new Exception("Json Data has no 'Traders' or 'Auctions' entry.");
        }
    }

    private UUID getPersistentTraderUUID(String traderID) {
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        if (this.persistentTraderIDs.containsValue(traderID)) {
            this.persistentTraderIDs.forEach((uuid, id) -> {
                if (id.contentEquals(traderID)) {
                    result.set(uuid);
                }
            });
        }
        return result.get();
    }

    private CompoundTag getPersistentData(String traderID) {
        for (int i = 0; i < this.persistentData.size(); ++i) {
            CompoundTag thisData = this.persistentData.m_128728_(i);
            if (!thisData.m_128461_("traderID").contentEquals(traderID)) continue;
            return thisData;
        }
        return new CompoundTag();
    }

    private void setPersistentData(String traderID, CompoundTag data) {
        for (int i = 0; i < this.persistentData.size(); ++i) {
            CompoundTag thisData = this.persistentData.m_128728_(i);
            if (!thisData.m_128461_("traderID").contentEquals(traderID)) continue;
            this.persistentData.set(i, (Tag)data);
            return;
        }
        this.persistentData.add((Object)data);
    }

    private void createPersistentTraderFile(File ptf) {
        File dir = new File(ptf.getParent());
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (dir.exists()) {
            try {
                ptf.createNewFile();
                FileUtil.writeStringToFile(ptf, "{\n    \"Traders\":[],\n    \"Auctions\":[]\n}");
                LightmansCurrency.LogInfo("persistentTraders.json does not exist. Creating a fresh copy.");
            }
            catch (Throwable e) {
                LightmansCurrency.LogError("Error attempting to create 'persistentTraders.json' file.", e);
            }
        }
    }

    public static UniversalTraderData getData(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.universalTraderMap.containsKey(traderID)) {
                return office.universalTraderMap.get(traderID);
            }
            if (office.persistentTraderMap.containsKey(traderID)) {
                return office.persistentTraderMap.get(traderID);
            }
        }
        return null;
    }

    public static List<UniversalTraderData> getTraders() {
        TradingOffice office = TradingOffice.get(ServerLifecycleHooks.getCurrentServer());
        List<UniversalTraderData> traders = office.universalTraderMap.values().stream().collect(Collectors.toList());
        traders.addAll(office.persistentTraderMap.values());
        return traders;
    }

    public static List<UniversalTraderData> filterTraders(String searchFilter, List<UniversalTraderData> traders) {
        if (searchFilter.isEmpty()) {
            return traders;
        }
        Stream<UniversalTraderData> stream = traders.stream().filter(entry -> {
            String searchText = searchFilter.toLowerCase().trim();
            if (entry.getName().getString().toLowerCase().contains(searchText)) {
                return true;
            }
            if (entry.getCoreSettings().getOwnerName().toLowerCase().contains(searchText)) {
                return true;
            }
            return TraderSearchFilter.checkFilters(entry, searchText);
        });
        return stream.collect(Collectors.toList());
    }

    public static List<UniversalTraderData> getTraders(String searchFilter) {
        return TradingOffice.filterTraders(searchFilter, TradingOffice.getTraders());
    }

    public static void MarkDirty(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            UniversalTraderData data = TradingOffice.getData(traderID);
            if (data != null) {
                CompoundTag compound = data.write(new CompoundTag());
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
            }
        }
    }

    public static void MarkDirty(UUID traderID, CompoundTag updateMessage) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            UniversalTraderData data = TradingOffice.getData(traderID);
            if (data != null) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(updateMessage));
            }
        }
    }

    public static List<Team> getTeams() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            return TradingOffice.get((MinecraftServer)server).playerTeams.values().stream().collect(Collectors.toList());
        }
        return new ArrayList<Team>();
    }

    public static Team getTeam(UUID teamID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.playerTeams.containsKey(teamID)) {
                return office.playerTeams.get(teamID);
            }
        }
        return null;
    }

    public static void MarkTeamDirty(UUID teamID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            Team team = TradingOffice.getTeam(teamID);
            if (team != null) {
                CompoundTag compound = team.save();
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientTeam(compound));
            }
        }
    }

    private UUID getValidTraderID() {
        UUID traderID = UUID.randomUUID();
        while (this.universalTraderMap.containsKey(traderID) || this.persistentTraderIDs.containsKey(traderID)) {
            traderID = UUID.randomUUID();
        }
        return traderID;
    }

    public static UUID registerTrader(UniversalTraderData data, @Nullable Player owner) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            UUID traderID = office.getValidTraderID();
            data.initTraderID(traderID);
            LightmansCurrency.LogInfo("Successfully registered the universal trader with id '" + traderID + "'!");
            office.universalTraderMap.put(traderID, data);
            office.m_77762_();
            CompoundTag compound = data.write(new CompoundTag());
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientData(compound));
            if (owner != null) {
                MinecraftForge.EVENT_BUS.post((Event)new UniversalTraderEvent.UniversalTradeCreateEvent(traderID, owner));
            }
            return traderID;
        }
        return null;
    }

    public static void removeTrader(UUID traderID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office.universalTraderMap.containsKey(traderID)) {
            UniversalTraderData removedData = office.universalTraderMap.get(traderID);
            office.universalTraderMap.remove(traderID);
            office.m_77762_();
            removedData.onRemoved();
            LightmansCurrency.LogInfo("Successfully removed the universal trader with id '" + traderID + "'!");
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageRemoveClientTrader(traderID));
            MinecraftForge.EVENT_BUS.post((Event)new UniversalTraderEvent.UniversalTradeRemoveEvent(traderID, removedData));
        }
    }

    public static Team registerTeam(Player owner, String teamName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            UUID teamID = UUID.randomUUID();
            while (office.playerTeams.containsKey(teamID)) {
                teamID = UUID.randomUUID();
            }
            Team newTeam = Team.of(teamID, PlayerReference.of(owner), teamName);
            office.playerTeams.put(teamID, newTeam);
            TradingOffice.MarkTeamDirty(newTeam.getID());
            return newTeam;
        }
        return null;
    }

    public static void removeTeam(UUID teamID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.playerTeams.containsKey(teamID)) {
                office.playerTeams.remove(teamID);
                office.m_77762_();
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageRemoveClientTeam(teamID));
            }
        }
    }

    public static List<BankAccount.AccountReference> getPlayerBankAccounts() {
        ArrayList<BankAccount.AccountReference> list = new ArrayList<BankAccount.AccountReference>();
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office != null) {
            office.playerBankAccounts.forEach((playerID, bankAccount) -> list.add(BankAccount.GenerateReference(false, BankAccount.AccountType.Player, playerID)));
        }
        return list;
    }

    public static BankAccount getBankAccount(Player player) {
        return TradingOffice.getBankAccount(player.m_142081_());
    }

    public static BankAccount getBankAccount(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office != null) {
            if (office.playerBankAccounts.containsKey(playerID)) {
                return office.playerBankAccounts.get(playerID);
            }
            BankAccount newAccount = new BankAccount(() -> TradingOffice.MarkBankAccountDirty(playerID));
            newAccount.updateOwnersName(PlayerReference.of(playerID, "Unknown").lastKnownName());
            office.playerBankAccounts.put(playerID, newAccount);
            TradingOffice.MarkBankAccountDirty(playerID);
            return newAccount;
        }
        return null;
    }

    public static void MarkBankAccountDirty(Player player) {
        if (player.f_19853_.f_46443_) {
            return;
        }
        TradingOffice.MarkBankAccountDirty(player.m_142081_());
    }

    public static void MarkBankAccountDirty(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            BankAccount bankAccount = TradingOffice.getBankAccount(playerID);
            CompoundTag compound = bankAccount.save();
            compound.m_128362_("Player", playerID);
            LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)new MessageUpdateClientBank(compound));
        }
    }

    public static NotificationData getNotifications(Player player) {
        return TradingOffice.getNotifications(player.m_142081_());
    }

    public static NotificationData getNotifications(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        TradingOffice office = TradingOffice.get(server);
        if (office != null) {
            if (office.playerNotifications.containsKey(playerID)) {
                return office.playerNotifications.get(playerID);
            }
            NotificationData newData = new NotificationData();
            office.playerNotifications.put(playerID, newData);
            TradingOffice.MarkNotificationsDirty(playerID);
            return newData;
        }
        return null;
    }

    public static boolean pushNotification(UUID playerID, Notification notification) {
        return TradingOffice.pushNotification(playerID, notification, true);
    }

    public static boolean pushNotification(UUID playerID, Notification notification, boolean pushToChat) {
        if (notification == null) {
            LightmansCurrency.LogError("Cannot push a null notification!");
            return false;
        }
        NotificationData data = TradingOffice.getNotifications(playerID);
        if (data != null) {
            ServerPlayer player;
            MinecraftServer server;
            NotificationEvent.NotificationSent.Pre event = new NotificationEvent.NotificationSent.Pre(playerID, data, notification);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return false;
            }
            data.addNotification(event.getNotification());
            TradingOffice.MarkNotificationsDirty(playerID);
            MinecraftForge.EVENT_BUS.post((Event)new NotificationEvent.NotificationSent.Post(playerID, data, event.getNotification()));
            if (pushToChat && (server = ServerLifecycleHooks.getCurrentServer()) != null && (player = server.m_6846_().m_11259_(playerID)) != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageClientNotification(notification));
            }
            return true;
        }
        return false;
    }

    public static void MarkNotificationsDirty(UUID playerID) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice.get(server).m_77762_();
            ServerPlayer player = server.m_6846_().m_11259_(playerID);
            if (player != null) {
                LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new MessageUpdateClientNotifications(TradingOffice.getNotifications(playerID)));
            }
        }
    }

    public static BankAccount.AccountReference getSelectedBankAccount(Player player) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (office.lastSelectedAccounts.containsKey(player.m_142081_())) {
                BankAccount.AccountReference account = office.lastSelectedAccounts.get(player.m_142081_());
                if (!account.allowedAccess(player)) {
                    LightmansCurrency.LogInfo(player.m_7755_().getString() + " is no longer allowed to access their selected bank account. Switching back to their personal account.");
                    account = BankAccount.GenerateReference(player);
                    TradingOffice.setSelectedBankAccount(player, account);
                }
                return account;
            }
            BankAccount.AccountReference account = BankAccount.GenerateReference(player);
            TradingOffice.setSelectedBankAccount(player, account);
            return account;
        }
        return BankAccount.GenerateReference(player);
    }

    public static void setSelectedBankAccount(Player player, BankAccount.AccountReference account) {
        if (account == null) {
            return;
        }
        if (!account.allowedAccess(player)) {
            LightmansCurrency.LogInfo("Player does not have access to the selected account. Canceling selection.");
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            office.lastSelectedAccounts.put(player.m_142081_(), account);
            office.m_77762_();
            LightmansCurrencyPacketHandler.instance.send(LightmansCurrencyPacketHandler.getTarget(player), (Object)new SPacketSyncSelectedBankAccount(account));
        }
    }

    private static TradingOffice get(MinecraftServer server) {
        ServerLevel world = server.m_129880_(Level.f_46428_);
        return (TradingOffice)world.m_8895_().m_164861_(TradingOffice::new, TradingOffice::new, DATA_NAME);
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getPlayer());
            TradingOffice office = TradingOffice.get(server);
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageClearClientTraders());
            office.universalTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundTag()))));
            office.persistentTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundTag()))));
            CompoundTag compound2 = new CompoundTag();
            ListTag teamList = new ListTag();
            office.playerTeams.forEach((id, team) -> teamList.add((Object)team.save()));
            compound2.m_128365_("Teams", (Tag)teamList);
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageInitializeClientTeams(compound2));
            TradingOffice.getBankAccount(event.getPlayer());
            CompoundTag compound3 = new CompoundTag();
            ListTag bankList = new ListTag();
            office.playerBankAccounts.forEach((id, team) -> {
                CompoundTag tag = team.save();
                tag.m_128362_("Player", id);
                bankList.add((Object)tag);
            });
            compound3.m_128365_("BankAccounts", (Tag)bankList);
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageInitializeClientBank(compound3));
            NotificationData notifications = TradingOffice.getNotifications(event.getPlayer());
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientNotifications(notifications));
            BankAccount.AccountReference selectedAccount = TradingOffice.getSelectedBankAccount(event.getPlayer());
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new SPacketSyncSelectedBankAccount(selectedAccount));
        }
    }

    private void resendTraderData() {
        PacketDistributor.PacketTarget target = PacketDistributor.ALL.noArg();
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageClearClientTraders());
        this.universalTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundTag()))));
        this.persistentTraderMap.forEach((id, trader) -> LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageUpdateClientData(trader.write(new CompoundTag()))));
    }

    @SubscribeEvent
    public static void onTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.START || !event.side.isServer()) {
            return;
        }
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            TradingOffice office = TradingOffice.get(server);
            if (server.m_129921_() % 1200 == 0) {
                office.universalTraderMap.values().removeIf(traderData -> {
                    if (traderData.shouldRemove(server)) {
                        traderData.onRemoved();
                        return true;
                    }
                    return false;
                });
            }
            if (server.m_129921_() % 20 == 0 && office.persistentAuctionData.size() > 0) {
                List traders = office.universalTraderMap.values().stream().collect(Collectors.toList());
                AuctionHouseTrader ah = null;
                for (int i = 0; i < traders.size() && ah == null; ++i) {
                    if (!(traders.get(i) instanceof AuctionHouseTrader)) continue;
                    ah = (AuctionHouseTrader)traders.get(i);
                }
                if (ah != null) {
                    for (PersistentAuctionData pad : office.persistentAuctionData) {
                        AuctionTradeData trade;
                        if (ah.hasPersistentAuction(pad.id) || (trade = pad.createAuction()) == null) continue;
                        ah.addTrade(trade);
                        LightmansCurrency.LogInfo("Successfully added Persistent Auction '" + pad.id + "' into the auction house.");
                    }
                }
            }
        }
    }

    public static boolean isAdminPlayer(Player player) {
        return adminPlayers.contains(player.m_142081_()) && player.m_20310_(2);
    }

    public static void toggleAdminPlayer(Player player) {
        UUID playerID = player.m_142081_();
        if (adminPlayers.contains(playerID)) {
            adminPlayers.remove(playerID);
            if (!player.f_19853_.f_46443_) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)TradingOffice.getAdminSyncMessage());
            }
        } else {
            adminPlayers.add(playerID);
            if (!player.f_19853_.f_46443_) {
                LightmansCurrencyPacketHandler.instance.send(PacketDistributor.ALL.noArg(), (Object)TradingOffice.getAdminSyncMessage());
            }
        }
    }

    public static MessageSyncAdminList getAdminSyncMessage() {
        return new MessageSyncAdminList(adminPlayers);
    }

    public static void loadAdminPlayers(List<UUID> serverAdminList) {
        adminPlayers = serverAdminList;
    }
}

