/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen;

import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.datagen.CoinMintRecipeBuilder;
import io.github.lightman314.lightmanscurrency.datagen.WalletUpgradeRecipeBuilder;
import java.util.function.Consumer;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class RecipeGen
extends RecipeProvider {
    private static final String UPGRADE_GROUP = "wallet_upgrades";

    public RecipeGen(DataGenerator generator) {
        super(generator);
    }

    protected void m_176531_(Consumer<FinishedRecipe> consumer) {
        RecipeGen.mint(consumer, (ItemLike)Items.f_151052_, (ItemLike)ModItems.COIN_COPPER);
        RecipeGen.melt(consumer, (ItemLike)Items.f_151052_, (ItemLike)ModItems.COIN_COPPER);
        RecipeGen.mint(consumer, (ItemLike)Items.f_42416_, (ItemLike)ModItems.COIN_IRON);
        RecipeGen.melt(consumer, (ItemLike)Items.f_42416_, (ItemLike)ModItems.COIN_IRON);
        RecipeGen.mint(consumer, (ItemLike)Items.f_42417_, (ItemLike)ModItems.COIN_GOLD);
        RecipeGen.melt(consumer, (ItemLike)Items.f_42417_, (ItemLike)ModItems.COIN_GOLD);
        RecipeGen.mint(consumer, (ItemLike)Items.f_42616_, (ItemLike)ModItems.COIN_EMERALD);
        RecipeGen.melt(consumer, (ItemLike)Items.f_42616_, (ItemLike)ModItems.COIN_EMERALD);
        RecipeGen.mint(consumer, (ItemLike)Items.f_42415_, (ItemLike)ModItems.COIN_DIAMOND);
        RecipeGen.melt(consumer, (ItemLike)Items.f_42415_, (ItemLike)ModItems.COIN_DIAMOND);
        RecipeGen.mint(consumer, (ItemLike)Items.f_42418_, (ItemLike)ModItems.COIN_NETHERITE);
        RecipeGen.melt(consumer, (ItemLike)Items.f_42418_, (ItemLike)ModItems.COIN_NETHERITE);
        RecipeGen.upgrade(consumer, (ItemLike)ModItems.WALLET_COPPER, (ItemLike)ModItems.WALLET_IRON, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.COIN_IRON}));
        RecipeGen.upgrade(consumer, (ItemLike)ModItems.WALLET_IRON, (ItemLike)ModItems.WALLET_GOLD, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.COIN_GOLD}));
        RecipeGen.upgrade(consumer, (ItemLike)ModItems.WALLET_GOLD, (ItemLike)ModItems.WALLET_EMERALD, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.COIN_EMERALD}));
        RecipeGen.upgrade(consumer, (ItemLike)ModItems.WALLET_EMERALD, (ItemLike)ModItems.WALLET_DIAMOND, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.COIN_DIAMOND}));
        RecipeGen.upgrade(consumer, (ItemLike)ModItems.WALLET_DIAMOND, (ItemLike)ModItems.WALLET_NETHERITE, Ingredient.m_43929_((ItemLike[])new ItemLike[]{ModItems.COIN_NETHERITE}));
    }

    private static void mint(Consumer<FinishedRecipe> consumer, ItemLike material, ItemLike coin) {
        CoinMintRecipeBuilder.minting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{material}), coin).save(consumer, RecipeGen.recipeId(CoinMintRecipe.MintType.MINT, coin));
    }

    private static void melt(Consumer<FinishedRecipe> consumer, ItemLike material, ItemLike coin) {
        CoinMintRecipeBuilder.melting(Ingredient.m_43929_((ItemLike[])new ItemLike[]{coin}), material).save(consumer, RecipeGen.recipeId(CoinMintRecipe.MintType.MELT, coin));
    }

    private static void upgrade(Consumer<FinishedRecipe> consumer, ItemLike walletIn, ItemLike walletOut, Ingredient ... materials) {
        WalletUpgradeRecipeBuilder.walletUpgrade(walletIn, walletOut, UPGRADE_GROUP, materials).save(consumer, RecipeGen.upgradeId(walletOut));
    }

    protected static ResourceLocation recipeId(CoinMintRecipe.MintType type, ItemLike coin) {
        String prefix = "coinmint_";
        if (type == CoinMintRecipe.MintType.MINT) {
            prefix = "mint_";
        } else if (type == CoinMintRecipe.MintType.MELT) {
            prefix = "melt_";
        }
        return RecipeGen.recipeId(prefix, coin);
    }

    protected static ResourceLocation recipeId(String prefix, ItemLike coin) {
        ResourceLocation coinItemID = coin.m_5456_().getRegistryName();
        return new ResourceLocation(coinItemID.m_135827_(), prefix + coinItemID.m_135815_());
    }

    protected static ResourceLocation upgradeId(ItemLike wallet) {
        ResourceLocation walletItemID = wallet.m_5456_().getRegistryName();
        return new ResourceLocation(walletItemID.m_135827_(), "upgraded_" + walletItemID.m_135815_());
    }
}

