/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus.traderstorage.trades_basic;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.BasicTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageTab;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BasicTradeEditTab
extends TraderStorageTab {
    public static final int INTERACTION_INPUT = 0;
    public static final int INTERACTION_OUTPUT = 1;
    public static final int INTERACTION_OTHER = 2;
    TraderStorageMenu.IClientMessage clientHandler = null;

    public BasicTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new BasicTradeEditClientTab<BasicTradeEditTab>(screen, this);
    }

    public void setClientHandler(TraderStorageMenu.IClientMessage clientHandler) {
        this.clientHandler = clientHandler;
    }

    @Override
    public boolean canOpen(Player player) {
        return true;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<Slot, Slot> addSlot) {
    }

    public void sendOpenTabMessage(int newTab, @Nullable CompoundTag additionalData) {
        CompoundTag message = this.menu.createTabChangeMessage(newTab, additionalData);
        if (this.clientHandler != null) {
            this.clientHandler.selfMessage(message);
        }
        this.menu.sendMessage(message);
    }

    public void sendInputInteractionMessage(int tradeIndex, int interactionIndex, int button, ItemStack heldItem) {
        CompoundTag message = new CompoundTag();
        message.m_128405_("TradeIndex", tradeIndex);
        message.m_128405_("InteractionType", 0);
        message.m_128405_("InteractionIndex", interactionIndex);
        message.m_128405_("Button", button);
        CompoundTag itemTag = new CompoundTag();
        heldItem.m_41739_(itemTag);
        message.m_128365_("HeldItem", (Tag)itemTag);
        this.menu.sendMessage(message);
    }

    public void sendOutputInteractionMessage(int tradeIndex, int interactionIndex, int button, ItemStack heldItem) {
        CompoundTag message = new CompoundTag();
        message.m_128405_("TradeIndex", tradeIndex);
        message.m_128405_("InteractionType", 1);
        message.m_128405_("InteractionIndex", interactionIndex);
        message.m_128405_("Button", button);
        CompoundTag itemTag = new CompoundTag();
        heldItem.m_41739_(itemTag);
        message.m_128365_("HeldItem", (Tag)itemTag);
        this.menu.sendMessage(message);
    }

    public void sendOtherInteractionMessage(int tradeIndex, int mouseX, int mouseY, int button, ItemStack heldItem) {
        CompoundTag message = new CompoundTag();
        message.m_128405_("TradeIndex", tradeIndex);
        message.m_128405_("InteractionType", 2);
        message.m_128405_("Button", button);
        message.m_128405_("MouseX", mouseX);
        message.m_128405_("MouseY", mouseX);
        CompoundTag itemTag = new CompoundTag();
        heldItem.m_41739_(itemTag);
        message.m_128365_("HeldItem", (Tag)itemTag);
        this.menu.sendMessage(message);
    }

    public void addTrade() {
        if (this.menu.getTrader() != null) {
            this.menu.getTrader().addTrade(this.menu.player);
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("AddTrade", true);
                this.menu.sendMessage(message);
            }
        }
    }

    public void removeTrade() {
        if (this.menu.getTrader() != null) {
            this.menu.getTrader().removeTrade(this.menu.player);
            if (this.menu.isClient()) {
                CompoundTag message = new CompoundTag();
                message.m_128379_("RemoveTrade", true);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(CompoundTag message) {
        if (message.m_128425_("TradeIndex", 3)) {
            int tradeIndex = message.m_128451_("TradeIndex");
            int interaction = message.m_128451_("InteractionType");
            int interactionIndex = message.m_128425_("InteractionIndex", 3) ? message.m_128451_("InteractionIndex") : 0;
            int button = message.m_128451_("Button");
            int mouseX = message.m_128425_("MouseX", 3) ? message.m_128451_("MouseX") : 0;
            int mouseY = message.m_128425_("MouseY", 3) ? message.m_128451_("MouseY") : 0;
            ItemStack heldItem = ItemStack.m_41712_((CompoundTag)message.m_128469_("HeldItem"));
            TradeButton.ITradeData trade = this.menu.getTrader().getTradeInfo().get(tradeIndex);
            switch (interaction) {
                case 0: {
                    trade.onInputDisplayInteraction(this, this.clientHandler, interactionIndex, button, heldItem);
                    break;
                }
                case 1: {
                    trade.onOutputDisplayInteraction(this, this.clientHandler, interactionIndex, button, heldItem);
                    break;
                }
                case 2: {
                    trade.onInteraction(this, this.clientHandler, mouseX, mouseY, button, heldItem);
                    break;
                }
                default: {
                    LightmansCurrency.LogWarning("Interaction Type " + interaction + " is not a valid interaction.");
                }
            }
            this.menu.getTrader().markTradesDirty();
        }
        if (message.m_128441_("AddTrade")) {
            this.addTrade();
        }
        if (message.m_128441_("RemoveTrade")) {
            this.removeTrade();
        }
    }
}

