/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.trader;

import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddOrRemoveTrade {
    BlockPos pos;
    boolean isTradeAdd;

    public MessageAddOrRemoveTrade(BlockPos pos, boolean isTradeAdd) {
        this.pos = pos;
        this.isTradeAdd = isTradeAdd;
    }

    public static void encode(MessageAddOrRemoveTrade message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.writeBoolean(message.isTradeAdd);
    }

    public static MessageAddOrRemoveTrade decode(FriendlyByteBuf buffer) {
        return new MessageAddOrRemoveTrade(buffer.m_130135_(), buffer.readBoolean());
    }

    public static void handle(MessageAddOrRemoveTrade message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) instanceof TraderBlockEntity) {
                TraderBlockEntity trader = (TraderBlockEntity)blockEntity;
                if (message.isTradeAdd) {
                    trader.addTrade((Player)player);
                } else {
                    trader.removeTrade((Player)player);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

