/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddOrRemoveTrade2 {
    UUID traderID;
    boolean isTradeAdd;

    public MessageAddOrRemoveTrade2(UUID traderID, boolean isTradeAdd) {
        this.traderID = traderID;
        this.isTradeAdd = isTradeAdd;
    }

    public static void encode(MessageAddOrRemoveTrade2 message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.traderID);
        buffer.writeBoolean(message.isTradeAdd);
    }

    public static MessageAddOrRemoveTrade2 decode(FriendlyByteBuf buffer) {
        return new MessageAddOrRemoveTrade2(buffer.m_130259_(), buffer.readBoolean());
    }

    public static void handle(MessageAddOrRemoveTrade2 message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData data;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (data = TradingOffice.getData(message.traderID)) != null) {
                if (message.isTradeAdd) {
                    data.addTrade((Player)player);
                } else {
                    data.removeTrade((Player)player);
                }
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

